/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.block;

import com.google.common.collect.Sets;
import cpw.mods.fml.common.event.FMLInterModComms;
import evilcraft.EvilCraft;
import evilcraft.IInitListener;
import evilcraft.block.SpiritFurnace;
import evilcraft.core.IMCHandler;
import evilcraft.core.config.ConfigurableProperty;
import evilcraft.core.config.ConfigurableTypeCategory;
import evilcraft.core.config.IChangedCallback;
import evilcraft.core.config.extendedconfig.BlockContainerConfig;
import evilcraft.core.helper.ItemHelpers;
import evilcraft.core.helper.MinecraftHelpers;
import evilcraft.core.helper.WeightedItemStack;
import evilcraft.core.item.ItemBlockNBT;
import evilcraft.core.tileentity.upgrade.Upgrades;
import evilcraft.tileentity.TileWorking;
import evilcraft.tileentity.tickaction.spiritfurnace.BoxCookTickAction;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.apache.logging.log4j.Level;

public class SpiritFurnaceConfig
extends BlockContainerConfig {
    private static final String DELIMITER = "\\|";
    public static SpiritFurnaceConfig _instance;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MACHINE, comment="How much mB per tick this furnace should consume.")
    public static int mBPerTick;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MACHINE, comment="How much mB per tick this furnace should consume for player spirit.")
    public static int playerMBPerTick;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MACHINE, comment="The required amount of ticks for each HP for cooking an entity.")
    public static int requiredTicksPerHp;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MACHINE, comment="If the machine should play mob death sounds.")
    public static boolean mobDeathSounds;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MACHINE, comment="The 1/X chance for villagers to drop emeralds. 0 means no drops.")
    public static int villagerDropEmeraldChance;
    @ConfigurableProperty(category=ConfigurableTypeCategory.MACHINE, comment="Custom player drops. Maps player UUID to an itemstack. Expects the format domain:itemname:amount:meta for items where amount and meta are optional.", changedCallback=OverridePlayerDrop.class)
    public static String[] playerDrops;

    public SpiritFurnaceConfig() {
        super(true, "spiritFurnace", (String)null, (Class<? extends Block>)SpiritFurnace.class);
    }

    @Override
    public Class<? extends ItemBlock> getItemBlockClass() {
        return ItemBlockNBT.class;
    }

    @Override
    public Set<Upgrades.Upgrade> getUpgrades() {
        return Sets.newHashSet((Object[])new Upgrades.Upgrade[]{TileWorking.UPGRADE_EFFICIENCY, TileWorking.UPGRADE_SPEED, TileWorking.UPGRADE_TIER1, TileWorking.UPGRADE_TIER2, TileWorking.UPGRADE_TIER3});
    }

    @Override
    public void onInit(IInitListener.Step step) {
        super.onInit(step);
        if (step == IInitListener.Step.INIT) {
            EvilCraft.IMC_HANDLER.registerAction("overrideSpiritFurnaceDrops", new IMCHandler.IIMCAction(){

                @Override
                public boolean handle(FMLInterModComms.IMCMessage message) {
                    if (!message.isNBTMessage()) {
                        return false;
                    }
                    try {
                        Class<?> clazz = Class.forName(message.getNBTValue().func_74779_i("entityClass"));
                        HashSet itemStacks = Sets.newHashSet();
                        NBTTagList list = message.getNBTValue().func_150295_c("items", MinecraftHelpers.NBTTag_Types.NBTTagCompound.ordinal());
                        if (list == null || list.func_74745_c() == 0) {
                            EvilCraft.log("IMC override mob drop has no items.", Level.ERROR);
                            return false;
                        }
                        for (int i = 0; i < list.func_74745_c(); ++i) {
                            NBTTagCompound tag = list.func_150305_b(i);
                            if (!tag.func_74764_b("item")) {
                                EvilCraft.log("IMC override mob drop has no item in the list.", Level.ERROR);
                                return false;
                            }
                            ItemStack itemStack = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("item"));
                            if (!tag.func_74764_b("weight")) {
                                EvilCraft.log("IMC override mob drop has no weight in the list.", Level.ERROR);
                                return false;
                            }
                            int weight = tag.func_74762_e("weight");
                            itemStacks.add(new WeightedItemStack(itemStack, weight));
                        }
                        BoxCookTickAction.overrideMobDrop(clazz, itemStacks);
                    }
                    catch (ClassNotFoundException e) {
                        EvilCraft.log("IMC override mob drop did not provide an existing entity class.", Level.ERROR);
                        return false;
                    }
                    catch (ClassCastException e) {
                        EvilCraft.log("IMC override mob drop did not provide an entity class of type EntityLivingBase.", Level.ERROR);
                        return false;
                    }
                    return true;
                }
            });
        }
    }

    static {
        mBPerTick = 25;
        playerMBPerTick = mBPerTick * 4;
        requiredTicksPerHp = 10;
        mobDeathSounds = true;
        villagerDropEmeraldChance = 20;
        playerDrops = new String[]{"93b459be-ce4f-4700-b457-c1aa91b3b687|minecraft:stone_slab"};
    }

    public static class OverridePlayerDrop
    implements IChangedCallback {
        private static boolean calledOnce = false;

        @Override
        public void onChanged(Object value) {
            if (calledOnce) {
                for (String line : playerDrops) {
                    String[] split = line.split(SpiritFurnaceConfig.DELIMITER);
                    if (split.length != 2) {
                        throw new IllegalArgumentException("Invalid line '" + line + "' found for a Spirit Furnace player drop config.");
                    }
                    try {
                        String playerId = split[0];
                        boolean validId = true;
                        try {
                            UUID.fromString(playerId);
                        }
                        catch (IllegalArgumentException e) {
                            validId = false;
                        }
                        if (!validId) {
                            EvilCraft.log("Invalid line '" + line + "' found for a Spirit Furnace player drop config: " + split[0] + " does not refer to a valid player UUID; skipping.");
                        }
                        try {
                            ItemStack itemStack = ItemHelpers.parseItemStack(split[1]);
                            BoxCookTickAction.overridePlayerDrop(playerId, itemStack);
                        }
                        catch (IllegalArgumentException e) {
                            EvilCraft.log("Invalid item '" + split[1] + "' in a Spirit Furnace player drop config; skipping:" + e.getMessage(), Level.ERROR);
                        }
                    }
                    catch (NumberFormatException e) {
                        EvilCraft.log("Invalid line '" + line + "' found for a Spirit Furnace player drop config: " + split[0] + " is not a number; skipping.");
                    }
                }
            }
            calledOnce = true;
        }

        @Override
        public void onRegisteredPostInit(Object value) {
            this.onChanged(value);
        }
    }
}

