/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.client.gui.container;

import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.core.algorithm.EvictingStack;
import evilcraft.core.helper.InventoryHelpers;
import evilcraft.core.helper.L10NHelpers;
import evilcraft.core.helper.MinecraftHelpers;
import evilcraft.core.helper.RenderHelpers;
import evilcraft.infobook.AdvancedButton;
import evilcraft.infobook.HyperLink;
import evilcraft.infobook.InfoBookRegistry;
import evilcraft.infobook.InfoSection;
import evilcraft.item.OriginsOfDarkness;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiOriginsOfDarkness
extends GuiScreen {
    protected static ResourceLocation texture = new ResourceLocation("evilcraft", OriginsOfDarkness.getInstance().getGuiTexture());
    private static final int BUTTON_NEXT = 1;
    private static final int BUTTON_PREVIOUS = 2;
    private static final int BUTTON_PARENT = 3;
    private static final int BUTTON_BACK = 4;
    private static final int BUTTON_HYPERLINKS_START = 5;
    private static final int HR_WIDTH = 88;
    private static final int HR_HEIGHT = 10;
    public static final int BANNER_WIDTH = 91;
    private static final int BANNER_HEIGHT = 12;
    private static final int ARROW_WIDTH = 22;
    private static final int ARROW_HEIGHT = 13;
    private static final int BORDER_CORNER = 4;
    private static final int BORDER_WIDTH = 2;
    private static final int BORDER_X = 0;
    private static final int BORDER_Y = 206;
    public static final int X_OFFSET_OUTER = 20;
    public static final int X_OFFSET_INNER = 7;
    public static final int X_OFFSET_TOTAL = 27;
    protected final ItemStack itemStack;
    private NextPageButton buttonNextPage;
    private NextPageButton buttonPreviousPage;
    private NextPageButton buttonParent;
    private NextPageButton buttonBack;
    private static InfoSection currentSection;
    private static int page;
    private static EvictingStack<InfoSection.Location> history;
    private InfoSection nextSection;
    private int nextPage;
    private boolean goToLastPage;
    private int guiWidth = 283;
    private int pageWidth = 142;
    private int guiHeight = 180;
    private int left;
    private int top;

    public GuiOriginsOfDarkness(EntityPlayer player, int itemIndex) {
        this.itemStack = InventoryHelpers.getItemFromIndex(player, itemIndex);
        if (currentSection == null) {
            currentSection = InfoBookRegistry.getInstance().getRoot();
            page = 0;
        }
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        super.func_73866_w_();
        this.left = (this.field_146294_l - this.guiWidth) / 2;
        this.top = (this.field_146295_m - this.guiHeight) / 2;
        this.buttonNextPage = new NextPageButton(1, this.left + this.pageWidth + 100, this.top + 156, 0, 180, 18, 13);
        this.field_146292_n.add(this.buttonNextPage);
        this.buttonPreviousPage = new NextPageButton(2, this.left + 23, this.top + 156, 0, 193, 18, 13);
        this.field_146292_n.add(this.buttonPreviousPage);
        this.buttonParent = new NextPageButton(3, this.left + 2, this.top + 2, 36, 180, 8, 8);
        this.field_146292_n.add(this.buttonParent);
        this.buttonBack = new NextPageButton(4, this.left + this.pageWidth + 127, this.top + 2, 0, 223, 13, 18);
        this.field_146292_n.add(this.buttonBack);
        this.updateGui();
        if (this.goToLastPage) {
            page = Math.max(0, currentSection.getPages() - 2);
            page += page % 2;
        }
        int nextId = 5;
        for (int innerPage = page; innerPage <= page + 1; ++innerPage) {
            for (HyperLink link : currentSection.getLinks(innerPage)) {
                int xOffset = innerPage % 2 == 1 ? 7 + this.pageWidth : 20;
                this.field_146292_n.add(new TextOverlayButton(nextId++, link, this.left + xOffset + link.getX(), this.top + 8 + link.getY(), InfoSection.getFontHeight(this.getFontRenderer())));
            }
            this.field_146292_n.addAll(currentSection.getAdvancedButtons(innerPage));
        }
    }

    public void func_73863_a(int x, int y, float f) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(texture);
        this.func_73729_b(this.left, this.top, 0, 0, this.pageWidth, this.guiHeight);
        this.drawTexturedModalRectMirrored(this.left + this.pageWidth - 1, this.top, 0, 0, this.pageWidth, this.guiHeight);
        int x0 = this.left + 20;
        int x1 = this.left + this.pageWidth - 1 + 7;
        int width = this.pageWidth - 27;
        currentSection.drawScreen(this, x0, this.top, width, this.guiHeight, page, x, y);
        currentSection.drawScreen(this, x1, this.top, width, this.guiHeight, page + 1, x, y);
        super.func_73863_a(x, y, f);
        currentSection.postDrawScreen(this, x0, this.top, width, this.guiHeight, page, x, y);
        currentSection.postDrawScreen(this, x1, this.top, width, this.guiHeight, page + 1, x, y);
    }

    public void drawTexturedModalRectMirrored(int x, int y, int u, int v, int width, int height) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0), (double)(y + height), (double)this.field_73735_i, (double)((float)(u + width) * f), (double)((float)(v + height) * f1));
        tessellator.func_78374_a((double)(x + width), (double)(y + height), (double)this.field_73735_i, (double)((float)(u + 0) * f), (double)((float)(v + height) * f1));
        tessellator.func_78374_a((double)(x + width), (double)(y + 0), (double)this.field_73735_i, (double)((float)(u + 0) * f), (double)((float)(v + 0) * f1));
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), (double)this.field_73735_i, (double)((float)(u + width) * f), (double)((float)(v + 0) * f1));
        tessellator.func_78381_a();
    }

    public boolean func_73868_f() {
        return false;
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    private void updateGui() {
        boolean oldUnicode = this.field_146297_k.field_71466_p.func_82883_a();
        this.field_146297_k.field_71466_p.func_78264_a(true);
        int width = this.pageWidth - 27;
        int lineHeight = InfoSection.getFontHeight(this.getFontRenderer());
        int maxLines = (this.guiHeight - 32 - 5) / lineHeight;
        LinkedList infoSectionsToBake = Lists.newLinkedList();
        infoSectionsToBake.add(currentSection);
        this.getPreviousSections(infoSectionsToBake);
        this.getNextSections(infoSectionsToBake);
        for (InfoSection infoSection : infoSectionsToBake) {
            if (infoSection == null) continue;
            infoSection.bakeSection(this.getFontRenderer(), width, maxLines, lineHeight);
        }
        this.updateButtons();
        this.field_146297_k.field_71466_p.func_78264_a(oldUnicode);
    }

    protected void getPreviousSections(List<InfoSection> sections) {
        InfoSection.Location location = currentSection.getPrevious(page, false);
        if (location != null) {
            sections.add(location.getInfoSection());
        }
    }

    protected void getNextSections(List<InfoSection> sections) {
        InfoSection.Location location = currentSection.getNext(page + 1, false);
        if (location != null) {
            sections.add(location.getInfoSection());
        }
    }

    private void updateButtons() {
        InfoSection.Location current1 = new InfoSection.Location(page, currentSection);
        InfoSection.Location current2 = new InfoSection.Location(page + 1, currentSection);
        InfoSection.Location wouldBeNext = currentSection.getNext(page + 1, false);
        this.buttonNextPage.field_146125_m = !current1.equals(wouldBeNext) && !current2.equals(wouldBeNext);
        this.buttonPreviousPage.field_146125_m = !current1.equals(currentSection.getPrevious(page, false));
        this.buttonParent.field_146125_m = currentSection != null && currentSection.getParent() != null;
        this.buttonBack.field_146125_m = history.currentSize() > 0;
    }

    protected void func_146284_a(GuiButton button) {
        this.goToLastPage = false;
        this.nextSection = currentSection;
        this.nextPage = page;
        if (button.field_146127_k == 1 && button.field_146125_m) {
            InfoSection.Location location = currentSection.getNext(page + 1, MinecraftHelpers.isShifted());
            this.nextSection = location.getInfoSection();
            this.nextPage = location.getPage();
            history.push(new InfoSection.Location(page, currentSection));
        } else if (button.field_146127_k == 2 && button.field_146125_m) {
            InfoSection.Location location = currentSection.getPrevious(page, MinecraftHelpers.isShifted());
            this.nextSection = location.getInfoSection();
            this.nextPage = location.getPage();
            this.goToLastPage = this.nextSection != currentSection && !MinecraftHelpers.isShifted();
            history.push(new InfoSection.Location(page, currentSection));
        } else if (button.field_146127_k == 3 && button.field_146125_m) {
            if (MinecraftHelpers.isShifted()) {
                this.nextSection = currentSection.getParent();
                while (this.nextSection.getParent() != null) {
                    this.nextSection = this.nextSection.getParent();
                }
            } else {
                this.nextSection = currentSection.getParent();
            }
            this.nextPage = 0;
            history.push(new InfoSection.Location(page, currentSection));
        } else if (button.field_146127_k == 4 && button.field_146125_m && history.currentSize() > 0) {
            InfoSection.Location location = history.pop();
            this.nextSection = location.getInfoSection();
            this.nextPage = location.getPage();
        } else if (button instanceof TextOverlayButton) {
            this.nextSection = ((TextOverlayButton)button).getLink().getTarget();
            this.nextPage = 0;
            if (this.nextSection != currentSection) {
                history.push(new InfoSection.Location(page, currentSection));
            }
        } else if (button instanceof AdvancedButton && ((AdvancedButton)button).isVisible()) {
            this.nextSection = ((AdvancedButton)button).getTarget();
            this.nextPage = 0;
            if (this.nextSection != currentSection) {
                history.push(new InfoSection.Location(page, currentSection));
            }
        } else {
            super.func_146284_a(button);
        }
    }

    protected void func_73864_a(int x, int y, int p_73864_3_) {
        super.func_73864_a(x, y, p_73864_3_);
        if (p_73864_3_ == 0 && this.nextSection != null && (this.nextSection != currentSection || page != this.nextPage)) {
            currentSection = this.nextSection;
            this.nextSection = null;
            page = this.nextPage;
            this.func_73866_w_();
        }
    }

    public void drawScaledCenteredString(String string, int x, int y, int width, float originalScale, int maxWidth, int color) {
        float originalWidth = (float)this.getFontRenderer().func_78256_a(string) * originalScale;
        float scale = Math.min(originalScale, (float)maxWidth / originalWidth * originalScale);
        this.drawScaledCenteredString(string, x, y, width, scale, color);
    }

    public void drawScaledCenteredString(String string, int x, int y, int width, float scale, int color) {
        GL11.glPushMatrix();
        GL11.glScalef((float)scale, (float)scale, (float)1.0f);
        int titleLength = this.field_146289_q.func_78256_a(string);
        int titleHeight = this.field_146289_q.field_78288_b;
        this.field_146289_q.func_78276_b(string, Math.round((float)(x + width / 2) / scale - (float)(titleLength / 2)), Math.round((float)y / scale - (float)(titleHeight / 2)), color);
        GL11.glPopMatrix();
    }

    public void drawHorizontalRule(int x, int y) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(texture);
        this.func_73729_b(x - 44, y - 5, 52, 180, 88, 10);
        GL11.glDisable((int)3042);
    }

    public void drawTextBanner(int x, int y) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(texture);
        this.func_73729_b(x - 45, y - 6, 52, 191, 91, 12);
        GL11.glDisable((int)3042);
    }

    public void drawArrowRight(int x, int y) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(texture);
        this.func_73729_b(x, y, 0, 210, 22, 13);
        GL11.glDisable((int)3042);
    }

    public void drawOuterBorder(int x, int y, int width, int height) {
        this.drawOuterBorder(x, y, width, height, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void drawOuterBorder(int x, int y, int width, int height, float r, float g, float b, float alpha) {
        int i;
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)alpha);
        this.field_146297_k.func_110434_K().func_110577_a(texture);
        this.func_73729_b(x - 2, y - 2, 0, 206, 4, 4);
        this.func_73729_b(x + width - 2, y - 2, 4, 206, 4, 4);
        this.func_73729_b(x - 2, y + height - 2, 12, 206, 4, 4);
        this.func_73729_b(x + width - 2, y + height - 2, 8, 206, 4, 4);
        for (i = 2; i < width - 2; i += 2) {
            int drawWidth = 2;
            if (i + 2 >= width - 4) {
                drawWidth -= i - (width - 4);
            }
            this.func_73729_b(x + i, y - 2, 16, 206, drawWidth, 2);
            this.func_73729_b(x + i, y + height, 16, 206, drawWidth, 2);
        }
        for (i = 2; i < height - 2; i += 2) {
            int drawHeight = 2;
            if (i + 2 >= height - 4) {
                drawHeight -= i - (height - 4);
            }
            if (drawHeight <= 0) continue;
            this.func_73729_b(x - 2, y + i, 16, 206, 2, drawHeight);
            this.func_73729_b(x + width, y + i, 16, 206, 2, drawHeight);
        }
        GL11.glDisable((int)3042);
    }

    public void func_146285_a(ItemStack itemStack, int x, int y) {
        super.func_146285_a(itemStack, x, y);
    }

    public int getTick() {
        return (int)this.field_146297_k.field_71441_e.func_72820_D();
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (!this.field_146297_k.field_71439_g.func_70089_S() || this.field_146297_k.field_71439_g.field_70128_L) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    static {
        history = new EvictingStack(128);
    }

    @SideOnly(value=Side.CLIENT)
    static class TextOverlayButton
    extends GuiButton {
        private HyperLink link;

        public TextOverlayButton(int id, HyperLink link, int x, int y, int height) {
            super(id, x, y, 0, height, InfoSection.formatString(L10NHelpers.localize(link.getUnlocalizedName())));
            this.link = link;
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            boolean oldUnicode = fontRenderer.func_82883_a();
            fontRenderer.func_78264_a(true);
            this.field_146120_f = fontRenderer.func_78256_a(this.field_146126_j);
            fontRenderer.func_78264_a(oldUnicode);
        }

        public void func_146112_a(Minecraft minecraft, int mouseX, int mouseY) {
            if (this.field_146125_m) {
                boolean isHover = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                boolean oldUnicode = minecraft.field_71466_p.func_82883_a();
                minecraft.field_71466_p.func_78264_a(true);
                minecraft.field_71466_p.func_78276_b((isHover ? "\u00a7n" : "") + this.field_146126_j + "\u00a7r", this.field_146128_h, this.field_146129_i, RenderHelpers.RGBToInt(isHover ? 100 : 0, isHover ? 100 : 0, isHover ? 150 : 125));
                minecraft.field_71466_p.func_78264_a(oldUnicode);
            }
        }

        public void func_146113_a(SoundHandler soundHandler) {
            soundHandler.func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("evilcraft", "pageFlip"), (float)1.0f));
        }

        public HyperLink getLink() {
            return this.link;
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class NextPageButton
    extends GuiButton {
        private int x;
        private int y;

        public NextPageButton(int id, int xPosition, int yPosition, int x, int y, int width, int height) {
            super(id, xPosition, yPosition, width, height, "");
            this.x = x;
            this.y = y;
        }

        public void func_146112_a(Minecraft minecraft, int mouseX, int mouseY) {
            if (this.field_146125_m) {
                boolean isHover = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                minecraft.func_110434_K().func_110577_a(texture);
                int k = this.x;
                int l = this.y;
                if (isHover) {
                    k += this.field_146120_f;
                }
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                this.func_73729_b(this.field_146128_h, this.field_146129_i, k, l, this.field_146120_f, this.field_146121_g);
                GL11.glDisable((int)3042);
            }
        }

        public void func_146113_a(SoundHandler soundHandler) {
            soundHandler.func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("evilcraft", "pageFlip"), (float)1.0f));
        }
    }
}

