/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.client.render.model;

import com.google.common.collect.Maps;
import evilcraft.client.render.model.ModelGem;
import evilcraft.core.client.render.model.ModelWavefront;
import java.util.Map;
import java.util.Random;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.obj.WavefrontObject;
import org.lwjgl.opengl.GL11;

public class ModelChalice
extends ModelWavefront {
    private static WavefrontObject model = new WavefrontObject(new ResourceLocation("evilcraft", "models/chalice.obj"));
    private ModelGem gem;
    private static Map<String, Long> seeds = Maps.newHashMap();
    private static int chaliceColor = 0;
    private static int gemColor = 0;

    public ModelChalice(ResourceLocation texture, ModelGem gem) {
        super(model, texture);
        this.gem = gem;
    }

    public static void setColorSeed(String id) {
        if (seeds.containsKey(id)) {
            long seed = seeds.get(id);
            chaliceColor = (int)(seed & 0x1FFFFFFL);
            gemColor = (int)(seed >> 24);
        } else {
            long res = id.hashCode();
            Random rand = new Random(res);
            chaliceColor = rand.nextInt(0x2000000);
            gemColor = rand.nextInt(0x2000000);
            seeds.put(id, (long)chaliceColor | (long)gemColor << 24);
        }
    }

    @Override
    public void renderAll() {
        float r = (float)(chaliceColor >> 16 & 0xFF) / 255.0f;
        float g = (float)(chaliceColor >> 8 & 0xFF) / 255.0f;
        float b = (float)(chaliceColor & 0xFF) / 255.0f;
        r = 0.95f - r / 5.0f;
        g = 0.9f - g / 5.0f;
        GL11.glColor3f((float)r, (float)g, (float)(b /= 5.0f));
        GL11.glTranslatef((float)0.5f, (float)0.24f, (float)0.5f);
        GL11.glScalef((float)0.3f, (float)0.22f, (float)0.3f);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        super.renderAll();
        r = (float)(gemColor >> 16 & 0xFF) / 255.0f;
        g = (float)(gemColor >> 8 & 0xFF) / 255.0f;
        b = (float)(gemColor & 0xFF) / 255.0f;
        GL11.glColor3f((float)r, (float)g, (float)b);
        GL11.glScalef((float)0.4f, (float)0.4f, (float)0.4f);
        for (int i = 0; i < 4; ++i) {
            GL11.glPushMatrix();
            GL11.glRotatef((float)((float)i * 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)-1.8f, (float)1.6f, (float)-0.5f);
            GL11.glRotatef((float)195.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            for (int j = -1; j <= 1; j += 2) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)((float)j * 1.2f));
                this.gem.renderAll();
                GL11.glPopMatrix();
            }
            GL11.glPopMatrix();
        }
    }
}

