/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.client.render.tileentity;

import evilcraft.client.render.model.ModelChalice;
import evilcraft.core.client.render.model.ModelWavefront;
import evilcraft.core.client.render.tileentity.RenderTileEntityModelWavefront;
import evilcraft.core.fluid.WorldSharedTank;
import evilcraft.core.helper.RenderHelpers;
import evilcraft.tileentity.TileEntangledChalice;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class RenderTileEntityEntangledChalice
extends RenderTileEntityModelWavefront {
    private static final float MIN = 0.2f;
    private static final float MAX = 0.8f;

    public RenderTileEntityEntangledChalice(ModelWavefront model, ResourceLocation texture) {
        super(model, texture);
    }

    @Override
    public void func_147500_a(TileEntity tile, double x, double y, double z, float f) {
        if (tile instanceof TileEntangledChalice) {
            final TileEntangledChalice chalice = (TileEntangledChalice)tile;
            ModelChalice.setColorSeed(((WorldSharedTank)chalice.getTank()).getTankID());
            super.func_147500_a(tile, x, y, z, f);
            FluidStack fluid = chalice.getTank().getFluid();
            RenderHelpers.renderTileFluidContext(fluid, x, y, z, tile, new RenderHelpers.IFluidContextRender(){

                @Override
                public void renderFluid(FluidStack fluid) {
                    RenderTileEntityEntangledChalice.renderFluidSide(fluid, chalice.getFillRatio());
                }
            });
        }
    }

    public static void renderFluidSide(FluidStack fluid, double fillRatio) {
        double height = fillRatio * 0.17 + (double)0.765f;
        float vertexOffset = Math.max(0.5f, Math.min(0.1f, 0.3f * ((float)(1.0 - fillRatio) * 0.9f + 0.005f)));
        float min = 0.2f + vertexOffset;
        float max = 0.8f - vertexOffset;
        float iconScale = (float)(1.0 - fillRatio) / 4.0f;
        IIcon icon = RenderHelpers.getFluidIcon(fluid, ForgeDirection.UP);
        Tessellator t = Tessellator.field_78398_a;
        t.func_78382_b();
        double minU = (icon.func_94212_f() - icon.func_94209_e()) * iconScale + icon.func_94209_e();
        double maxU = icon.func_94212_f() - (icon.func_94212_f() - icon.func_94209_e()) * iconScale;
        double minV = (icon.func_94210_h() - icon.func_94206_g()) * iconScale + icon.func_94206_g();
        double maxV = icon.func_94210_h() - (icon.func_94210_h() - icon.func_94206_g()) * iconScale;
        t.func_78374_a((double)min, height, (double)min, minU, maxV);
        t.func_78374_a((double)min, height, (double)max, minU, minV);
        t.func_78374_a((double)max, height, (double)max, maxU, minV);
        t.func_78374_a((double)max, height, (double)min, maxU, maxV);
        t.func_78381_a();
    }
}

