/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.client.render.tileentity;

import evilcraft.tileentity.TilePurifier;
import evilcraft.tileentity.tickaction.purifier.DisenchantPurifyAction;
import net.minecraft.client.model.ModelBook;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class RenderTileEntityPurifier
extends TileEntitySpecialRenderer {
    private static final ResourceLocation TEXTURE_BLOOK = new ResourceLocation("evilcraft", "textures/entities/blook.png");
    private static final ResourceLocation TEXTURE_ENCHANTEDBOOK = new ResourceLocation("evilcraft", "textures/entities/enchantedBook.png");
    private ModelBook enchantmentBook = new ModelBook();

    public void func_147500_a(TileEntity tileEntity, double x, double y, double z, float partialTickTime) {
        ItemStack additionalItem;
        TilePurifier tile = (TilePurifier)tileEntity;
        if (tile != null && (additionalItem = tile.getAdditionalItem()) != null) {
            if (additionalItem.func_77973_b() == DisenchantPurifyAction.ALLOWED_BOOK || additionalItem.func_77973_b() == Items.field_151134_bR) {
                this.renderBook(tile, tile.func_145831_w(), additionalItem, x, y + 0.4, z, partialTickTime);
            } else {
                this.renderAdditionalItem(tile, tile.func_145831_w(), additionalItem, x, y + 0.4, z, partialTickTime);
            }
        }
        GL11.glPushMatrix();
        float var10 = (float)(x - 0.5);
        float var11 = (float)(y - 0.5);
        float var12 = (float)(z - 0.5);
        GL11.glTranslatef((float)var10, (float)var11, (float)var12);
        if (tile != null && tile.getPurifyItem() != null) {
            this.renderItem(tile.func_145831_w(), tile.getPurifyItem(), tile.getRandomRotation());
        }
        GL11.glPopMatrix();
    }

    private void renderItem(World world, ItemStack itemStack, float rotation) {
        GL11.glPushMatrix();
        if (itemStack.func_77973_b() instanceof ItemBlock) {
            GL11.glTranslatef((float)1.0f, (float)0.675f, (float)1.0f);
            GL11.glScalef((float)1.8f, (float)1.8f, (float)1.8f);
        } else {
            GL11.glTranslatef((float)1.0f, (float)0.875f, (float)0.8f);
            GL11.glRotatef((float)25.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)25.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
        }
        RenderItem.field_82407_g = true;
        EntityItem entity = new EntityItem(world, 0.0, 0.0, 0.0, itemStack);
        entity.field_70290_d = 0.0f;
        RenderManager.field_78727_a.func_147940_a((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        RenderItem.field_82407_g = false;
        GL11.glPopMatrix();
    }

    private void renderAdditionalItem(TilePurifier tile, World world, ItemStack itemStack, double x, double y, double z, float partialTickTime) {
        float speedUp;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.75f), (float)((float)z + 0.5f));
        float tick = (float)tile.tickCount.intValue() + partialTickTime;
        GL11.glTranslatef((float)0.0f, (float)(0.1f + MathHelper.func_76126_a((float)(tick * 0.1f)) * 0.01f), (float)0.0f);
        if (itemStack.func_77973_b() instanceof ItemBlock) {
            GL11.glTranslatef((float)1.0f, (float)0.675f, (float)1.0f);
            GL11.glScalef((float)1.8f, (float)1.8f, (float)1.8f);
        } else {
            GL11.glRotatef((float)25.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
        }
        for (speedUp = tile.additionalRotation2.floatValue() - tile.additionalRotationPrev.floatValue(); speedUp >= (float)Math.PI; speedUp -= (float)Math.PI * 2) {
        }
        while (speedUp < (float)(-Math.PI)) {
            speedUp += (float)Math.PI * 2;
        }
        float rotation = tile.additionalRotationPrev.floatValue() + speedUp * partialTickTime;
        GL11.glRotatef((float)(-rotation * 180.0f / (float)Math.PI), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderItem.field_82407_g = true;
        EntityItem entity = new EntityItem(world, 0.0, 0.0, 0.0, itemStack);
        entity.field_70290_d = 0.0f;
        RenderManager.field_78727_a.func_147940_a((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        RenderItem.field_82407_g = false;
        GL11.glPopMatrix();
    }

    private void renderBook(TilePurifier tile, World world, ItemStack itemStack, double x, double y, double z, float partialTickTime) {
        float speedUp;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.75f), (float)((float)z + 0.5f));
        float tick = (float)tile.tickCount.intValue() + partialTickTime;
        GL11.glTranslatef((float)0.0f, (float)(0.1f + MathHelper.func_76126_a((float)(tick * 0.1f)) * 0.01f), (float)0.0f);
        for (speedUp = tile.additionalRotation2.floatValue() - tile.additionalRotationPrev.floatValue(); speedUp >= (float)Math.PI; speedUp -= (float)Math.PI * 2) {
        }
        while (speedUp < (float)(-Math.PI)) {
            speedUp += (float)Math.PI * 2;
        }
        float rotation = tile.additionalRotationPrev.floatValue() + speedUp * partialTickTime;
        GL11.glRotatef((float)(-rotation * 180.0f / (float)Math.PI), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)80.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        if (itemStack.func_77973_b() == DisenchantPurifyAction.ALLOWED_BOOK) {
            this.func_147499_a(TEXTURE_BLOOK);
        } else {
            this.func_147499_a(TEXTURE_ENCHANTEDBOOK);
        }
        GL11.glEnable((int)2884);
        this.enchantmentBook.func_78088_a((Entity)null, tick, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        GL11.glPopMatrix();
    }
}

