/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.client.render.tileentity;

import evilcraft.core.helper.RenderHelpers;
import evilcraft.tileentity.TileSpiritPortal;
import java.util.Random;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderTileEntitySpiritPortal
extends TileEntitySpecialRenderer {
    private static final ResourceLocation PORTALBASE = new ResourceLocation("evilcraft", "textures/models/portalBases.png");

    public void func_147500_a(TileEntity tileentity, double x, double y, double z, float partialTickTime) {
        this.renderTileEntityAt((TileSpiritPortal)tileentity, x, y, z, partialTickTime);
    }

    protected void renderTileEntityAt(TileSpiritPortal tileentity, double x, double y, double z, float partialTickTime) {
        float progress = tileentity.getProgress();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        this.renderPortalBase((float)x, (float)y, (float)z, progress);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        Random random = new Random();
        int seed = tileentity.field_145851_c + tileentity.field_145848_d + tileentity.field_145849_e;
        random.setSeed(seed);
        this.renderStar(seed, progress, Tessellator.field_78398_a, partialTickTime, random);
        GL11.glPopMatrix();
    }

    private void renderStar(float rotation, float progress, Tessellator tessellator, float partialTicks, Random random) {
        GL11.glRotatef((float)(rotation * -0.2f % 360.0f), (float)0.5f, (float)1.0f, (float)0.5f);
        float BEAM_START_DISTANCE = 2.0f;
        float BEAM_END_DISTANCE = 7.0f;
        float MAX_OPACITY = 40.0f;
        RenderHelper.func_74518_a();
        float f2 = 0.0f;
        if (progress > 0.8f) {
            f2 = (progress - 0.8f) / 0.2f;
        }
        GL11.glDisable((int)3553);
        GL11.glShadeModel((int)7425);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)2884);
        GL11.glDepthMask((boolean)false);
        int color1 = RenderHelpers.RGBToInt(171, 97, 210);
        int color2 = RenderHelpers.RGBToInt(175, 100, 215);
        int i = 0;
        while ((float)i < (progress + progress * progress) / 2.0f * 60.0f) {
            GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(random.nextFloat() * 360.0f + progress * 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            tessellator.func_78371_b(6);
            float f3 = random.nextFloat() * BEAM_END_DISTANCE + 5.0f + f2 * 10.0f;
            float f4 = random.nextFloat() * BEAM_START_DISTANCE + 1.0f + f2 * 2.0f;
            tessellator.func_78380_c(255);
            tessellator.func_78384_a(color1, (int)(MAX_OPACITY * (1.0f - f2)));
            tessellator.func_78377_a(0.0, 0.0, 0.0);
            tessellator.func_78384_a(color2, 0);
            tessellator.func_78377_a(-0.866 * (double)f4, (double)f3, (double)(-0.5f * f4));
            tessellator.func_78377_a(0.866 * (double)f4, (double)f3, (double)(-0.5f * f4));
            tessellator.func_78377_a(0.0, (double)f3, (double)(1.0f * f4));
            tessellator.func_78377_a(-0.866 * (double)f4, (double)f3, (double)(-0.5f * f4));
            tessellator.func_78381_a();
            ++i;
        }
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glShadeModel((int)7424);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3008);
        RenderHelper.func_74519_b();
    }

    private void renderPortalBase(float x, float y, float z, float progress) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)z);
        GL11.glEnable((int)32826);
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glColor3f((float)0.72f, (float)0.5f, (float)0.83f);
        this.func_147499_a(PORTALBASE);
        Tessellator tessellator = Tessellator.field_78398_a;
        RenderManager renderManager = RenderManager.field_78727_a;
        float r = 180.0f - renderManager.field_78735_i;
        GL11.glRotatef((float)r, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-renderManager.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        this.renderIconForProgress(tessellator, (int)(progress * 100.0f) % 4, progress);
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }

    private void renderIconForProgress(Tessellator tessellator, int index, float progress) {
        if (progress > 0.8f) {
            progress -= (progress - 0.8f) * 4.0f;
        }
        float u1 = 0.0625f * (float)index;
        float u2 = 0.0625f * (float)(index + 1);
        float v1 = 0.0f;
        float v2 = 0.0625f;
        GL11.glScalef((float)(0.5f * progress), (float)(0.5f * progress), (float)(0.5f * progress));
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)0.0f);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        tessellator.func_78380_c(100);
        tessellator.func_78374_a(0.0, 1.0, 0.0, (double)u1, (double)v2);
        tessellator.func_78374_a(0.0, 0.0, 0.0, (double)u1, (double)v1);
        tessellator.func_78374_a(1.0, 0.0, 0.0, (double)u2, (double)v1);
        tessellator.func_78374_a(1.0, 1.0, 0.0, (double)u2, (double)v2);
        tessellator.func_78381_a();
    }
}

