/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core;

import evilcraft.EvilCraft;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.Level;

public class Debug {
    private static String CONFIGCHECKER_PREFIX = "[CONFIGCHECKER] ";
    private static Set<ExtendedConfig> savedConfigs = new HashSet<ExtendedConfig>();
    private static boolean ok = true;

    public static void checkPreConfigurables(Set<ExtendedConfig> configs) {
        for (ExtendedConfig config : configs) {
            try {
                config.getClass().getField("_instance");
            }
            catch (NoSuchFieldException e) {
                Debug.log(config + " has no static '_instance' field.");
            }
            catch (SecurityException e) {
                Debug.log(config + " has a non-public static '_instance' field, make it public.");
            }
        }
        savedConfigs.addAll(configs);
    }

    public static void checkPostConfigurables() {
        for (ExtendedConfig config : savedConfigs) {
            if (!config.getHolderType().hasUniqueInstance() || !config.isEnabled()) continue;
            if (config.getSubInstance() == null) {
                Debug.log(config.getElement() + " has no sub-instance, even though it is enabled.");
            }
            try {
                config.getElement().getMethod("initInstance", ExtendedConfig.class);
            }
            catch (NoSuchMethodException e) {
                Debug.log(config.getElement() + " has no static 'initInstance(ExtendedConfig eConfig)' method.");
            }
            catch (SecurityException e) {
                Debug.log(config.getElement() + " has a non-public static 'initInstance(ExtendedConfig eConfig)' method, make it public.");
            }
            try {
                config.getElement().getMethod("getInstance", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                Debug.log(config.getElement() + " has no static 'getInstance()' method.");
            }
            catch (SecurityException e) {
                Debug.log(config.getElement() + " has a non-public static 'getInstance()' method, make it public.");
            }
        }
        if (ok) {
            EvilCraft.log(CONFIGCHECKER_PREFIX + "Everything is just fine!");
        }
    }

    private static void log(String message) {
        ok = false;
        EvilCraft.log(CONFIGCHECKER_PREFIX + message, Level.INFO);
    }
}

