/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core;

import com.google.common.collect.Maps;
import cpw.mods.fml.common.event.FMLInterModComms;
import evilcraft.EvilCraft;
import java.util.Map;
import org.apache.logging.log4j.Level;

public class IMCHandler {
    private Map<String, IIMCAction> actions = Maps.newHashMap();

    public void registerAction(String key, IIMCAction action) {
        this.actions.put(key, action);
    }

    public void handle(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            this.handle(message);
        }
    }

    public void handle(FMLInterModComms.IMCMessage message) {
        EvilCraft.log(String.format("Handling IMC message from %s.", message.getSender()), Level.INFO);
        IIMCAction action = this.actions.get(message.key);
        if (action != null) {
            if (!action.handle(message)) {
                EvilCraft.log(String.format("The IMC message for key %s was rejected. It may have been incorrectly formatted or has resulted in an error.", message.key), Level.ERROR);
            }
        } else {
            EvilCraft.log(String.format("An IMC message with invalid key %s was received.", message.key), Level.ERROR);
        }
    }

    public static interface IIMCAction {
        public boolean handle(FMLInterModComms.IMCMessage var1);
    }
}

