/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core;

import baubles.api.BaublesApi;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import evilcraft.core.PlayerInventoryIterator;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

@Optional.Interface(iface="baubles.api.IBauble", modid="Baubles", striprefs=true)
public class PlayerExtendedInventoryIterator
implements Iterator<ItemStack> {
    private PlayerInventoryIterator innerIt;
    private boolean hasIteratedInner = false;
    private int maxBaublesSize;
    private int baublesIterator = this.maxBaublesSize = 4;
    private EntityPlayer player;

    public PlayerExtendedInventoryIterator(EntityPlayer player) {
        this.player = player;
        this.innerIt = new PlayerInventoryIterator(player);
        if (Loader.isModLoaded((String)"Baubles")) {
            this.setBaublesData();
        }
    }

    @Override
    public boolean hasNext() {
        return !this.hasIteratedInner || this.baublesIterator < this.maxBaublesSize;
    }

    @Override
    public ItemStack next() {
        if (this.hasIteratedInner && this.hasNext()) {
            ItemStack itemStack = this.getBaublesStack(this.baublesIterator);
            ++this.baublesIterator;
            return itemStack;
        }
        ItemStack next = this.innerIt.next();
        if (!this.innerIt.hasNext()) {
            this.hasIteratedInner = true;
        }
        return next;
    }

    @Optional.Method(modid="Baubles")
    protected ItemStack getBaublesStack(int index) {
        return BaublesApi.getBaubles((EntityPlayer)this.player).func_70301_a(index);
    }

    @Optional.Method(modid="Baubles")
    protected void setBaublesStack(int index, ItemStack itemStack) {
        BaublesApi.getBaubles((EntityPlayer)this.player).func_70299_a(index, itemStack);
    }

    @Optional.Method(modid="Baubles")
    protected void setBaublesData() {
        this.maxBaublesSize = BaublesApi.getBaubles((EntityPlayer)this.player).func_70302_i_();
        this.baublesIterator = 0;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not implemented.");
    }

    public void replace(ItemStack itemStack) {
        if (this.hasIteratedInner && this.baublesIterator > 0) {
            this.setBaublesStack(this.baublesIterator - 1, itemStack);
        } else {
            this.innerIt.replace(itemStack);
        }
    }
}

