/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.algorithm;

import evilcraft.api.ILocation;
import evilcraft.core.algorithm.Size;
import net.minecraft.nbt.NBTTagCompound;

public class Location
implements ILocation {
    private int[] coordinates;

    public Location(int ... coordinates) {
        this.coordinates = coordinates;
    }

    @Override
    public int getDimensions() {
        return this.coordinates.length;
    }

    @Override
    public int[] getCoordinates() {
        return this.coordinates;
    }

    @Override
    public void setCoordinates(int[] coordinates) {
        this.coordinates = coordinates;
    }

    @Override
    public Size getDifference(ILocation location) {
        if (location.getDimensions() != this.getDimensions()) {
            throw new IllegalArgumentException("The dimensions of this and the given dimension are not the same.");
        }
        int[] diffs = new int[this.getDimensions()];
        for (int i = 0; i < diffs.length; ++i) {
            diffs[i] = Math.abs(location.getCoordinates()[i] - this.getCoordinates()[i]);
        }
        return new Size(diffs);
    }

    @Override
    public int getDistance(ILocation location) {
        Size difference = this.getDifference(location);
        int distance = 0;
        for (int i = 0; i < difference.getDimensions(); ++i) {
            distance += difference.getSizes()[i];
        }
        return (int)Math.pow(distance, 1 / difference.getDimensions());
    }

    @Override
    public ILocation copy() {
        return new Location((int[])this.coordinates.clone());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        boolean first = true;
        for (int coord : this.getCoordinates()) {
            if (!first) {
                builder.append(';');
            }
            first = false;
            builder.append(coord);
        }
        builder.append("]");
        return builder.toString();
    }

    public boolean equals(Object object) {
        return object instanceof ILocation && ((ILocation)object).getCoordinates().equals(this.getCoordinates());
    }

    @Override
    public int compareTo(ILocation o) {
        if (this.getDimensions() != o.getDimensions()) {
            return this.getDimensions() - o.getDimensions();
        }
        boolean validBuffer = false;
        int buffer = Integer.MAX_VALUE;
        for (int i = 0; i < this.getDimensions(); ++i) {
            if (this.getCoordinates()[i] == o.getCoordinates()[i]) continue;
            int comp = this.getCoordinates()[i] - o.getCoordinates()[i];
            if (comp < 0) {
                return comp;
            }
            validBuffer = true;
            buffer = Math.min(buffer, comp);
        }
        return validBuffer ? buffer : 0;
    }

    @Override
    public NBTTagCompound toNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74783_a("coordinates", this.getCoordinates());
        return tag;
    }

    @Override
    public void fromNBT(NBTTagCompound tag) {
        this.setCoordinates(tag.func_74759_k("coordinates"));
    }

    @Override
    public ILocation subtract(ILocation location) {
        if (this.getDimensions() != location.getDimensions()) {
            throw new IllegalArgumentException("The dimensions differ: this: [" + this.getDimensions() + "] subtractor [" + location.getDimensions() + "]");
        }
        int[] result = new int[this.getDimensions()];
        for (int i = 0; i < this.getDimensions(); ++i) {
            result[i] = this.getCoordinates()[i] - location.getCoordinates()[i];
        }
        ILocation ret = this.copy();
        ret.setCoordinates(result);
        return ret;
    }

    @Override
    public ILocation add(ILocation location) {
        if (this.getDimensions() != location.getDimensions()) {
            throw new IllegalArgumentException("The dimensions differ: this: [" + this.getDimensions() + "] adder [" + location.getDimensions() + "]");
        }
        int[] result = new int[this.getDimensions()];
        for (int i = 0; i < this.getDimensions(); ++i) {
            result[i] = this.getCoordinates()[i] + location.getCoordinates()[i];
        }
        ILocation ret = this.copy();
        ret.setCoordinates(result);
        return ret;
    }
}

