/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.algorithm;

public class SingleCache<K, V> {
    private boolean initialized = false;
    private K key = null;
    private V value = null;
    private ICacheUpdater<K, V> updater;

    public SingleCache(ICacheUpdater<K, V> updater) {
        this.updater = updater;
    }

    public V get(K key) {
        if (!this.initialized || !this.updater.isKeyEqual(this.key, key)) {
            this.value = this.updater.getNewValue(key);
            this.key = key;
            this.initialized = true;
        }
        return this.value;
    }

    public static interface ICacheUpdater<K, V> {
        public V getNewValue(K var1);

        public boolean isKeyEqual(K var1, K var2);
    }
}

