/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.block;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import evilcraft.api.ILocation;
import evilcraft.api.ISize;
import evilcraft.core.algorithm.Dimension;
import evilcraft.core.algorithm.Location;
import evilcraft.core.algorithm.Size;
import evilcraft.core.block.AllowedBlock;
import evilcraft.core.helper.LocationHelpers;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.world.World;

public class CubeDetector {
    private static Size NULL_SIZE = Size.NULL_SIZE.copy();
    private Collection<AllowedBlock> allowedBlocks = Sets.newHashSet();
    private Map<Block, AllowedBlock> blockInfo = Maps.newHashMap();
    private List<? extends IDetectionListener> listeners;
    private Size minimumSize = NULL_SIZE;
    private Size exactSize = NULL_SIZE;
    private Map<Block, Integer> blockOccurences;

    public CubeDetector(AllowedBlock[] allowedBlocks, List<? extends IDetectionListener> listeners) {
        this.addAllowedBlocks(allowedBlocks);
        this.listeners = listeners;
    }

    public Collection<AllowedBlock> getAllowedBlocks() {
        return this.allowedBlocks;
    }

    public void addAllowedBlocks(AllowedBlock[] allowedBlocks) {
        for (AllowedBlock block : allowedBlocks) {
            this.blockInfo.put(block.getBlock(), block);
            this.allowedBlocks.add(block);
        }
    }

    public Size getMinimumSize() {
        return this.minimumSize;
    }

    public CubeDetector setMinimumSize(Size minimumSize) {
        this.minimumSize = minimumSize;
        if (this.getExactSize() != NULL_SIZE) {
            throw new IllegalStateException("Can not set both a minimum and exact size.");
        }
        return this;
    }

    public Size getExactSize() {
        return this.exactSize;
    }

    public CubeDetector setExactSize(Size exactSize) {
        this.exactSize = exactSize;
        if (this.getMinimumSize() != NULL_SIZE) {
            throw new IllegalStateException("Can not set both a minimum and exact size.");
        }
        return this;
    }

    public List<? extends IDetectionListener> getListeners() {
        return this.listeners;
    }

    protected void notifyListeners(World world, ILocation location, Size size, boolean valid, ILocation originCorner) {
        for (IDetectionListener iDetectionListener : this.getListeners()) {
            iDetectionListener.onDetect(world, location, size, valid, originCorner);
        }
    }

    protected boolean isValidLocation(World world, ILocation location, IValidationAction action) {
        Block block = world.func_147439_a(location.getCoordinates()[0], location.getCoordinates()[1], location.getCoordinates()[2]);
        boolean contains = this.blockInfo.containsKey(block);
        if (contains && action != null) {
            action.onValidate(location, block);
        }
        return contains;
    }

    protected boolean isValidLocation(World world, ILocation location) {
        return this.isValidLocation(world, location, null);
    }

    protected boolean isAir(World world, ILocation location) {
        return world.func_147437_c(location.getCoordinates()[0], location.getCoordinates()[1], location.getCoordinates()[2]);
    }

    protected ILocation navigateToBorder(World world, ILocation startLocation, int dimension, int direction) {
        ILocation loopLocation = startLocation.copy();
        while (this.isValidLocation(world, loopLocation)) {
            int[] nArray = loopLocation.getCoordinates();
            int n = dimension;
            nArray[n] = nArray[n] + direction;
        }
        int[] nArray = loopLocation.getCoordinates();
        int n = dimension;
        nArray[n] = nArray[n] - direction;
        return loopLocation;
    }

    protected ILocation navigateToBorder(World world, ILocation startLocation, int dimension, boolean max) {
        ILocation location = this.navigateToBorder(world, startLocation, dimension, max ? 1 : -1);
        return location;
    }

    protected ILocation navigateToCorner(World world, ILocation startLocation, int[] dimensions, boolean max) {
        ILocation navigateLocation = startLocation.copy();
        for (int dimension : dimensions) {
            navigateLocation = this.navigateToBorder(world, navigateLocation, dimension, max);
        }
        return navigateLocation;
    }

    protected boolean isEdge(World world, int[][] dimensionEgdes, ILocation location) {
        for (int i = 0; i < dimensionEgdes.length; ++i) {
            for (int j = 0; j < dimensionEgdes[i].length; ++j) {
                if (dimensionEgdes[i][j] != location.getCoordinates()[i]) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean validateLocationInStructure(World world, int[][] dimensionEgdes, ILocation location, IValidationAction action) {
        return this.isValidLocation(world, location, action);
    }

    protected boolean coordinateRecursion(World world, int[][] dimensionEgdes, ILocationAction locationAction) {
        return this.coordinateRecursion(world, dimensionEgdes, new int[0], locationAction);
    }

    protected boolean coordinateRecursion(World world, int[][] dimensionEgdes, int[] accumulatedCoordinates, ILocationAction locationAction) {
        if (accumulatedCoordinates.length == dimensionEgdes.length) {
            Location location = new Location(accumulatedCoordinates);
            if (!locationAction.run(world, location)) {
                return false;
            }
        } else {
            int dimension = accumulatedCoordinates.length;
            int i = dimensionEgdes[dimension][0];
            while (i <= dimensionEgdes[dimension][1]) {
                int[] newAccumulatedCoordinates = Arrays.copyOf(accumulatedCoordinates, accumulatedCoordinates.length + 1);
                newAccumulatedCoordinates[accumulatedCoordinates.length] = i++;
                if (this.coordinateRecursion(world, dimensionEgdes, newAccumulatedCoordinates, locationAction)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean validateAllowedBlockConditions(World world, ILocation location) {
        Block block = LocationHelpers.getBlock(world, location);
        if (this.blockInfo.containsKey(block)) {
            int occurences = this.blockOccurences.get(block);
            AllowedBlock allowed = this.blockInfo.get(block);
            if (allowed.getMaxOccurences() >= 0 && occurences >= allowed.getMaxOccurences()) {
                return false;
            }
            this.blockOccurences.put(block, occurences + 1);
        }
        return true;
    }

    protected boolean validateDimensionEdges(World world, final int[][] dimensionEgdes, final boolean valid, final IValidationAction action) {
        this.blockOccurences = Maps.newHashMap();
        for (AllowedBlock block : this.allowedBlocks) {
            this.blockOccurences.put(block.getBlock(), 0);
        }
        boolean minimumValid = this.coordinateRecursion(world, dimensionEgdes, new ILocationAction(){

            @Override
            public boolean run(World world, ILocation location) {
                return (!valid || CubeDetector.this.validateAllowedBlockConditions(world, location)) && CubeDetector.this.validateLocationInStructure(world, dimensionEgdes, location, action);
            }
        });
        if (minimumValid) {
            for (AllowedBlock allowed : this.allowedBlocks) {
                int occurences = this.blockOccurences.get(allowed.getBlock());
                if (allowed.getExactOccurences() < 0 || occurences == allowed.getExactOccurences()) continue;
                return !valid;
            }
        }
        return minimumValid;
    }

    protected void postValidate(World world, final Size size, int[][] dimensionEgdes, final boolean valid, final ILocation originCorner) {
        this.coordinateRecursion(world, dimensionEgdes, new ILocationAction(){

            @Override
            public boolean run(World world, ILocation location) {
                CubeDetector.this.notifyListeners(world, location, size, valid, originCorner);
                return true;
            }
        });
    }

    public Size detect(World world, ILocation startLocation, boolean valid, boolean changeState) {
        return this.detect(world, startLocation, valid, null, changeState);
    }

    public Size detect(World world, ILocation startLocation, boolean valid, IValidationAction action, boolean changeState) {
        if (!this.isValidLocation(world, startLocation)) {
            return NULL_SIZE.copy();
        }
        ILocation tempOriginCorner = this.navigateToCorner(world, startLocation, new int[]{2, 1, 0}, true);
        ILocation originCorner = this.navigateToCorner(world, tempOriginCorner, new int[]{0, 1, 2}, false);
        ILocation[] corners = new ILocation[Dimension.DIMENSIONS.length];
        for (int i = 0; i < corners.length; ++i) {
            corners[i] = this.navigateToCorner(world, originCorner, new int[]{i}, true);
        }
        int[] distances = new int[corners.length];
        int[][] dimensionEgdes = new int[corners.length][2];
        for (int i = 0; i < corners.length; ++i) {
            ISize sizeDifference = corners[i].getDifference(originCorner);
            distances[i] = sizeDifference.getCoordinates()[i];
            int addIndex = 0;
            if (originCorner.getCoordinates()[i] > corners[i].getCoordinates()[i]) {
                addIndex = 1;
            }
            dimensionEgdes[i][(0 + addIndex) % 2] = originCorner.getCoordinates()[i];
            dimensionEgdes[i][(1 + addIndex) % 2] = corners[i].getCoordinates()[i];
        }
        if (!this.validateDimensionEdges(world, dimensionEgdes, valid, action)) {
            return NULL_SIZE.copy();
        }
        Size size = new Size(distances);
        if (this.getMinimumSize() != NULL_SIZE && size.compareTo(this.getMinimumSize()) < 0 && valid) {
            return NULL_SIZE.copy();
        }
        if (this.getExactSize() != NULL_SIZE && size.compareTo(this.getExactSize()) != 0 && valid) {
            return NULL_SIZE.copy();
        }
        this.postValidate(world, size, dimensionEgdes, valid, originCorner);
        return size;
    }

    public static interface IValidationAction {
        public void onValidate(ILocation var1, Block var2);
    }

    protected static interface ILocationAction {
        public boolean run(World var1, ILocation var2);
    }

    public static interface IDetectionListener {
        public void onDetect(World var1, ILocation var2, Size var3, boolean var4, ILocation var5);
    }
}

