/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.block;

import evilcraft.api.ILocation;
import evilcraft.core.algorithm.Size;
import evilcraft.core.block.AllowedBlock;
import evilcraft.core.block.CubeDetector;
import java.util.List;
import net.minecraft.world.World;

public class HollowCubeDetector
extends CubeDetector {
    public HollowCubeDetector(AllowedBlock[] allowedBlocks, List<? extends CubeDetector.IDetectionListener> listeners) {
        super(allowedBlocks, listeners);
    }

    @Override
    protected void postValidate(World world, final Size size, final int[][] dimensionEgdes, final boolean valid, final ILocation originCorner) {
        this.coordinateRecursion(world, dimensionEgdes, new CubeDetector.ILocationAction(){

            @Override
            public boolean run(World world, ILocation location) {
                if (HollowCubeDetector.this.isEdge(world, dimensionEgdes, location) && HollowCubeDetector.this.isValidLocation(world, location)) {
                    HollowCubeDetector.this.notifyListeners(world, location, size, valid, originCorner);
                }
                return true;
            }
        });
    }

    @Override
    protected boolean validateLocationInStructure(World world, int[][] dimensionEgdes, ILocation location, CubeDetector.IValidationAction action) {
        return !(this.isEdge(world, dimensionEgdes, location) ? !this.isValidLocation(world, location, action) : !this.isAir(world, location));
    }
}

