/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.client.render.block;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import evilcraft.core.client.render.block.CustomRenderBlocks;
import evilcraft.core.client.render.block.IMultiRenderPassBlock;
import evilcraft.core.helper.DirectionHelpers;
import evilcraft.core.helper.RenderHelpers;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class MultiPassBlockRenderer
implements ISimpleBlockRenderingHandler {
    public static int ID = RenderingRegistry.getNextAvailableRenderId();
    protected CustomRenderBlocks renderBlocks = new CustomRenderBlocks();

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        GL11.glEnable((int)32826);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.renderInventoryBlock(renderer, block, metadata);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        this.renderBlocks.setWorld(world);
        this.renderBlocks.func_147775_a(block);
        boolean visible = false;
        if (block instanceof IMultiRenderPassBlock) {
            IMultiRenderPassBlock blockToRender = (IMultiRenderPassBlock)block;
            blockToRender.setInventoryBlock(false);
            blockToRender.setRenderBlocks(this.renderBlocks);
            blockToRender.setRenderPass(0);
            if (this.renderBlocks.func_147784_q(block, x, y, z)) {
                visible = true;
                for (int pass = 1; pass < blockToRender.getRenderPasses(); ++pass) {
                    if (!blockToRender.shouldRender(pass)) continue;
                    this.renderBlocks.func_147757_a(renderer.field_147840_d);
                    blockToRender.setRenderBlocks(this.renderBlocks);
                    blockToRender.setRenderPass(pass);
                    this.renderBlocks.func_147784_q(block, x, y, z);
                    this.renderBlocks.func_147771_a();
                    this.resetFacesOnRenderer(this.renderBlocks);
                }
            }
            blockToRender.setInventoryBlock(true);
            blockToRender.setRenderPass(-1);
            blockToRender.setRenderBlocks(null);
        }
        return visible;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return ID;
    }

    private void renderInventoryBlock(RenderBlocks renderer, Block block, int metaData) {
        Tessellator tessellator = Tessellator.field_78398_a;
        block.func_149683_g();
        renderer.func_147775_a(block);
        GL11.glPushMatrix();
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        if (block instanceof IMultiRenderPassBlock) {
            IMultiRenderPassBlock blockToRender = (IMultiRenderPassBlock)block;
            blockToRender.setInventoryBlock(true);
            for (int pass = 0; pass < blockToRender.getRenderPasses(); ++pass) {
                blockToRender.setRenderPass(pass);
                for (ForgeDirection renderDirection : DirectionHelpers.DIRECTIONS) {
                    tessellator.func_78382_b();
                    tessellator.func_78375_b((float)renderDirection.offsetX, (float)renderDirection.offsetY, (float)renderDirection.offsetZ);
                    RenderHelpers.renderFaceDirection(renderDirection, renderer, block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, renderDirection.ordinal(), metaData));
                    tessellator.func_78381_a();
                }
            }
        }
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    private void resetFacesOnRenderer(RenderBlocks renderer) {
        renderer.field_147867_u = 0;
        renderer.field_147865_v = 0;
        renderer.field_147875_q = 0;
        renderer.field_147869_t = 0;
        renderer.field_147871_s = 0;
        renderer.field_147867_u = 0;
        renderer.field_147873_r = 0;
        renderer.field_147842_e = false;
    }
}

