/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.config;

import com.google.common.collect.Maps;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import evilcraft.EvilCraft;
import evilcraft.IInitListener;
import evilcraft.command.CommandConfig;
import evilcraft.core.config.ConfigProperty;
import evilcraft.core.config.ConfigurableType;
import evilcraft.core.config.IChangedCallback;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import java.util.LinkedHashSet;
import java.util.Map;
import net.minecraftforge.common.config.Configuration;

public class ConfigHandler
extends LinkedHashSet<ExtendedConfig> {
    private static final long serialVersionUID = 1L;
    private static ConfigHandler _instance = null;
    private Configuration config;
    private LinkedHashSet<ExtendedConfig> processedConfigs = new LinkedHashSet();
    private Map<String, ExtendedConfig> configDictionary = Maps.newHashMap();

    public static ConfigHandler getInstance() {
        if (_instance == null) {
            _instance = new ConfigHandler();
        }
        return _instance;
    }

    @Override
    public boolean add(ExtendedConfig e) {
        this.configDictionary.put(e.getNamedId(), e);
        return super.add(e);
    }

    public void handle(FMLPreInitializationEvent event) {
        if (this.getConfig() == null) {
            Configuration config = new Configuration(event.getSuggestedConfigurationFile());
            this.setConfig(config);
            config.load();
        }
        this.loadConfig();
    }

    public void loadConfig() {
        for (ExtendedConfig eConfig : this) {
            if (eConfig.isHardDisabled()) continue;
            for (ConfigProperty configProperty : eConfig.configProperties) {
                configProperty.save(this.config);
                if (!configProperty.isCommandable()) continue;
                CommandConfig.PROPERTIES.put(configProperty.getName(), configProperty);
            }
            ConfigurableType type = eConfig.getHolderType();
            type.getElementTypeAction().commonRun(eConfig, this.config);
            if (!eConfig.isEnabled()) continue;
            eConfig.onRegistered();
            EvilCraft.log("Registered " + eConfig.getNamedId());
            this.processedConfigs.add(eConfig);
            EvilCraft.addInitListeners(new ConfigInitListener(eConfig));
        }
        this.removeAll(this);
        this.config.save();
    }

    public void syncProcessedConfigs() {
        for (ExtendedConfig eConfig : this.processedConfigs) {
            for (ConfigProperty configProperty : eConfig.configProperties) {
                configProperty.save(this.config, false);
            }
            ConfigurableType type = eConfig.getHolderType();
            type.getElementTypeAction().preRun(eConfig, this.config, false);
        }
        this.getConfig().save();
    }

    public Configuration getConfig() {
        return this.config;
    }

    public void setConfig(Configuration config) {
        this.config = config;
    }

    public Map<String, ExtendedConfig> getDictionary() {
        return this.configDictionary;
    }

    public static class ConfigInitListener
    implements IInitListener {
        private ExtendedConfig<?> config;

        public ConfigInitListener(ExtendedConfig<?> config) {
            this.config = config;
        }

        @Override
        public void onInit(IInitListener.Step step) {
            this.config.onInit(step);
            if (step == IInitListener.Step.POSTINIT) {
                for (ConfigProperty property : this.config.configProperties) {
                    IChangedCallback changedCallback = property.getCallback().getChangedCallback();
                    if (changedCallback == null) continue;
                    changedCallback.onRegisteredPostInit(property.getValue());
                }
            }
        }
    }
}

