/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.config.configurable;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.core.DirectionCorner;
import evilcraft.core.client.render.block.ConnectableIcon;
import evilcraft.core.client.render.block.CustomRenderBlocks;
import evilcraft.core.client.render.block.MultiPassBlockRenderer;
import evilcraft.core.config.configurable.ConfigurableBlock;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.core.helper.DirectionHelpers;
import evilcraft.core.helper.RenderHelpers;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class ConfigurableBlockConnectedTexture
extends ConfigurableBlock {
    protected int pass = 0;
    protected CustomRenderBlocks renderer;
    protected ConnectableIcon connectableIcon;
    protected IIcon blockIconBorder;
    protected IIcon blockIconCorner;
    protected IIcon blockIconInnerCorner;
    protected IIcon blockIconInventory;

    public ConfigurableBlockConnectedTexture(ExtendedConfig eConfig, Material material) {
        super(eConfig, material);
    }

    public IIcon getIconBackground() {
        return this.field_149761_L;
    }

    public IIcon getIconBorders() {
        return this.blockIconBorder;
    }

    public IIcon getIconCorners() {
        return this.blockIconCorner;
    }

    public IIcon getIconInnerCorners() {
        return this.blockIconInnerCorner;
    }

    public IIcon getIconInventory() {
        return this.hasSeperateInventoryBlockIcon() ? this.blockIconInventory : this.field_149761_L;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return MultiPassBlockRenderer.ID;
    }

    public boolean shouldConnect(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public boolean shouldConnectDirection(IBlockAccess world, ForgeDirection side, int x, int y, int z) {
        return this.shouldConnect(world, x, y, z) && world.func_147439_a(x + side.offsetX, y + side.offsetY, z + side.offsetZ) == this;
    }

    public boolean shouldConnectDirection(IBlockAccess world, DirectionCorner side, int x, int y, int z) {
        return this.shouldConnect(world, x, y, z) && world.func_147439_a(x + side.offsetX, y + side.offsetY, z + side.offsetZ) == this;
    }

    @Override
    public void setRenderPass(int pass) {
        this.pass = pass < this.getRenderPasses() ? pass : this.getRenderPasses() - 1;
    }

    @Override
    public boolean shouldRender(int pass) {
        return pass == 0 || pass >= 4;
    }

    @Override
    public void setRenderBlocks(CustomRenderBlocks renderer) {
        this.renderer = renderer;
    }

    @Override
    public CustomRenderBlocks getRenderBlocks() {
        return this.renderer;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        super.func_149651_a(iconRegister);
        this.blockIconBorder = iconRegister.func_94245_a(this.func_149641_N() + "_border");
        this.blockIconCorner = iconRegister.func_94245_a(this.func_149641_N() + "_corner");
        this.blockIconInnerCorner = iconRegister.func_94245_a(this.func_149641_N() + "_innerCorner");
        if (this.hasSeperateInventoryBlockIcon()) {
            this.blockIconInventory = iconRegister.func_94245_a(this.func_149641_N() + "_inventory");
        }
        this.connectableIcon = new ConnectableIcon(this.getIconBackground(), this.getIconBorders(), this.getIconCorners(), this.getIconInnerCorners(), this.getIconInventory());
        RenderHelpers.EMPTYICON = iconRegister.func_94245_a("evilcraft:empty");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.getIcon(side, meta, this.pass);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta, int renderPass) {
        if (this.getRenderBlocks() != null) {
            this.connectableIcon.prepareIcon(side, renderPass, this.getRenderBlocks());
        }
        return this.connectableIcon;
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        this.updateConnections(world, x, y, z);
        return super.func_149673_e(world, x, y, z, side);
    }

    @Override
    public int getRenderPasses() {
        return this.connectableIcon.getRequiredPasses();
    }

    private void updateConnections(IBlockAccess world, int x, int y, int z) {
        boolean connect;
        for (ForgeDirection forgeDirection : DirectionHelpers.DIRECTIONS) {
            connect = this.shouldConnectDirection(world, forgeDirection, x, y, z);
            this.connectableIcon.connect(forgeDirection, connect);
        }
        for (DirectionCorner directionCorner : DirectionHelpers.DIRECTIONS_CORNERS) {
            connect = this.shouldConnectDirection(world, directionCorner, x, y, z);
            this.connectableIcon.connectCorner(directionCorner, connect);
        }
    }

    @Override
    public void setInventoryBlock(boolean isInventoryBlock) {
        this.connectableIcon.setInventoryBlock(isInventoryBlock);
    }

    public boolean hasSeperateInventoryBlockIcon() {
        return false;
    }
}

