/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.config.configurable;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.core.PlayerExtendedInventoryIterator;
import evilcraft.core.config.configurable.IConfigurable;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.core.helper.L10NHelpers;
import evilcraft.core.item.DamageIndicatedItemFluidContainer;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public abstract class ConfigurableDamageIndicatedItemFluidContainer
extends DamageIndicatedItemFluidContainer
implements IConfigurable {
    protected ExtendedConfig eConfig = null;
    protected boolean canPickUp = true;
    private boolean placeFluids = false;

    protected ConfigurableDamageIndicatedItemFluidContainer(ExtendedConfig eConfig, int capacity, Fluid fluid) {
        super(capacity, fluid);
        this.setConfig(eConfig);
        this.func_77655_b(eConfig.getUnlocalizedName());
    }

    private void setConfig(ExtendedConfig eConfig) {
        this.eConfig = eConfig;
    }

    @Override
    public ExtendedConfig<?> getConfig() {
        return this.eConfig;
    }

    public String func_111208_A() {
        return "evilcraft:" + this.eConfig.getNamedId();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a(this.func_111208_A());
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        FluidStack fluidStack = this.getFluid(itemStack);
        FluidStack drained = this.drain(itemStack, 1000, false);
        Block block = this.getFluid().getBlock();
        boolean hasBucket = drained != null && drained.amount == 1000;
        boolean hasSpace = fluidStack == null || fluidStack.amount + 1000 <= this.getCapacity(itemStack);
        MovingObjectPosition movingobjectpositionDrain = this.func_77621_a(world, player, false);
        MovingObjectPosition movingobjectpositionFill = this.func_77621_a(world, player, true);
        if (movingobjectpositionDrain != null && movingobjectpositionFill != null) {
            int z;
            int y;
            int x;
            if (this.isPickupFluids() && movingobjectpositionFill.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                x = movingobjectpositionFill.field_72311_b;
                y = movingobjectpositionFill.field_72312_c;
                z = movingobjectpositionFill.field_72309_d;
                if (!world.func_72962_a(player, x, y, z)) {
                    return itemStack;
                }
                if (!player.func_82247_a(x, y, z, movingobjectpositionFill.field_72310_e, itemStack)) {
                    return itemStack;
                }
                if (world.func_147439_a(x, y, z) == block && world.func_72805_g(x, y, z) == 0) {
                    if (hasSpace) {
                        world.func_147468_f(x, y, z);
                        this.fill(itemStack, new FluidStack(this.getFluid(), 1000), true);
                    }
                    return itemStack;
                }
            }
            if (hasBucket && this.isPlaceFluids() && movingobjectpositionDrain.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                x = movingobjectpositionDrain.field_72311_b;
                y = movingobjectpositionDrain.field_72312_c;
                z = movingobjectpositionDrain.field_72309_d;
                if (!world.func_72962_a(player, x, y, z)) {
                    return itemStack;
                }
                ForgeDirection direction = ForgeDirection.getOrientation((int)movingobjectpositionDrain.field_72310_e);
                if (!player.func_82247_a(x += direction.offsetX, y += direction.offsetY, z += direction.offsetZ, movingobjectpositionDrain.field_72310_e, itemStack)) {
                    return itemStack;
                }
                if (this.tryPlaceContainedLiquid(world, x, y, z, block, true)) {
                    this.drain(itemStack, 1000, true);
                    return itemStack;
                }
            }
        }
        return itemStack;
    }

    private boolean tryPlaceContainedLiquid(World world, int x, int y, int z, Block block, boolean hasBucket) {
        if (!hasBucket) {
            return false;
        }
        Material material = world.func_147439_a(x, y, z).func_149688_o();
        if (!world.func_147437_c(x, y, z) && material.func_76220_a()) {
            return false;
        }
        if (!(world.field_72995_K || material.func_76220_a() || material.func_76224_d())) {
            world.func_147480_a(x, y, z, true);
        }
        world.func_147465_d(x, y, z, block, 0, 3);
        return true;
    }

    public boolean func_82788_x() {
        return true;
    }

    public boolean isPlaceFluids() {
        return this.placeFluids;
    }

    public boolean isPickupFluids() {
        return this.canPickUp;
    }

    public void setPlaceFluids(boolean placeFluids) {
        this.placeFluids = placeFluids;
    }

    public boolean onItemUseFirst(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        L10NHelpers.addOptionalInfo(list, this.func_77658_a());
        super.func_77624_a(itemStack, entityPlayer, list, par4);
    }

    protected FluidStack drainFromOthers(int amount, ItemStack itemStack, Fluid fluid, EntityPlayer player, boolean doDrain) {
        PlayerExtendedInventoryIterator it = new PlayerExtendedInventoryIterator(player);
        FluidStack drained = null;
        while (it.hasNext() && amount > 0) {
            FluidStack thisDrained;
            IFluidContainerItem containerItem;
            FluidStack totalFluid;
            ItemStack current = it.next();
            if (current == null || current == itemStack || !(current.func_77973_b() instanceof IFluidContainerItem) || (totalFluid = (containerItem = (IFluidContainerItem)current.func_77973_b()).getFluid(current)) == null || totalFluid.getFluid() != fluid || (thisDrained = containerItem.drain(current, amount, doDrain)) == null || thisDrained.getFluid() != fluid) continue;
            if (drained == null) {
                drained = thisDrained;
            } else {
                drained.amount += drained.amount;
            }
            amount -= drained.amount;
        }
        return drained;
    }

    public boolean canConsume(int amount, ItemStack itemStack, EntityPlayer player) {
        if (this.canDrain(amount, itemStack)) {
            return true;
        }
        int availableAmount = 0;
        if (this.getFluid(itemStack) != null) {
            availableAmount = this.getFluid((ItemStack)itemStack).amount;
        }
        return this.drainFromOthers(amount - availableAmount, itemStack, this.getFluid(), player, false) != null;
    }

    public FluidStack consume(int amount, ItemStack itemStack, EntityPlayer player) {
        boolean doDrain;
        boolean bl = doDrain = !player.field_71075_bZ.field_75098_d && !player.field_70170_p.field_72995_K;
        if (amount == 0) {
            return null;
        }
        FluidStack drained = this.drain(itemStack, amount, doDrain);
        if (drained != null && drained.amount == amount) {
            return drained;
        }
        int drainedAmount = drained == null ? 0 : drained.amount;
        int toDrain = amount - drainedAmount;
        FluidStack otherDrained = this.drainFromOthers(toDrain, itemStack, this.getFluid(), player, doDrain);
        if (otherDrained == null) {
            return drained;
        }
        otherDrained.amount += drainedAmount;
        return otherDrained;
    }
}

