/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.config.configurable;

import cpw.mods.fml.common.registry.VillagerRegistry;
import evilcraft.core.config.configurable.IConfigurable;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.core.config.extendedconfig.VillagerConfig;
import evilcraft.core.helper.WeightedItemStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.item.ItemStack;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;

public class ConfigurableVillager
implements IConfigurable,
VillagerRegistry.IVillageTradeHandler {
    protected ExtendedConfig<VillagerConfig> eConfig = null;
    protected List<WeightedItemStack> allowedTradeInputs = new ArrayList<WeightedItemStack>();
    protected List<WeightedItemStack> allowedTradeOutputs = new ArrayList<WeightedItemStack>();
    protected int maxWeightDifference = 25;
    protected int inputMinStackSize = 1;
    protected int inputMaxStackSize = 64;
    protected int addedRecipes = 0;
    protected int requiredAddedRecipes = 10;
    private int attemptAddRecipeUpperbound = 100;
    private int attemptAddRecipe = 0;

    protected ConfigurableVillager(ExtendedConfig eConfig) {
        this.setConfig(eConfig);
    }

    private void setConfig(ExtendedConfig eConfig) {
        this.eConfig = eConfig;
    }

    @Override
    public ExtendedConfig<?> getConfig() {
        return this.eConfig;
    }

    public void manipulateTradesForVillager(EntityVillager villager, MerchantRecipeList recipeList, Random random) {
        if (villager.func_70946_n() == this.eConfig.downCast().getId()) {
            this.addedRecipes = 0;
            this.attemptAddRecipe = 0;
            while (this.addedRecipes < this.requiredAddedRecipes && this.attemptAddRecipe < this.attemptAddRecipeUpperbound) {
                WeightedItemStack outputWeighted = this.getRandomOutput(random);
                WeightedItemStack inputAWeighted = this.getRandomInput(random);
                if (this.tryAddingRecipe(recipeList, random, inputAWeighted, null, outputWeighted)) continue;
                WeightedItemStack inputBWeighted = this.getRandomInput(random);
                this.tryAddingRecipe(recipeList, random, inputAWeighted, inputBWeighted, outputWeighted);
            }
        }
    }

    private boolean tryAddingRecipe(MerchantRecipeList recipeList, Random random, WeightedItemStack inputAWeighted, WeightedItemStack inputBWeighted, WeightedItemStack outputWeighted) {
        ItemStack inputB;
        ++this.attemptAddRecipe;
        int inputWeight = inputAWeighted.getWeight() * 64;
        inputWeight = inputBWeighted != null ? (inputWeight += inputBWeighted.getWeight() * 64) : (inputWeight *= 2);
        if (outputWeighted.getWeight() - inputWeight >= this.maxWeightDifference) {
            if (inputBWeighted == null) {
                return false;
            }
            inputWeight -= inputBWeighted.getWeight() * 64;
            inputBWeighted = null;
            if (Math.abs(outputWeighted.getWeight() - inputWeight) >= this.maxWeightDifference) {
                return false;
            }
        }
        int totalInputWeight = 0;
        ItemStack inputA = inputAWeighted.getItemStack().func_77946_l();
        inputA.field_77994_a = this.getRandomBetween(random, inputA.field_77994_a, this.getRandomBetween(random, this.inputMinStackSize, this.inputMaxStackSize));
        if (inputA.field_77994_a > inputA.func_77976_d()) {
            inputA.field_77994_a = inputA.func_77976_d();
        }
        totalInputWeight += inputA.field_77994_a * inputAWeighted.getWeight() / inputAWeighted.getItemStack().field_77994_a;
        if (inputBWeighted != null) {
            inputB = inputAWeighted.getItemStack().func_77946_l();
            inputB.field_77994_a = this.getRandomBetween(random, inputB.field_77994_a, this.getRandomBetween(random, this.inputMinStackSize, this.inputMaxStackSize));
            if (inputB.field_77994_a > inputB.func_77976_d()) {
                inputB.field_77994_a = inputB.func_77976_d();
            }
            totalInputWeight += inputB.field_77994_a * inputBWeighted.getWeight() / inputBWeighted.getItemStack().field_77994_a;
        } else {
            inputB = null;
        }
        ItemStack output = outputWeighted.getItemStack().func_77946_l();
        output.field_77994_a = Math.min(64, outputWeighted.getItemStack().field_77994_a * (int)this.safeDivide(totalInputWeight, outputWeighted.getWeight()));
        if (output.field_77994_a == 0) {
            return false;
        }
        if (output.field_77994_a > output.func_77976_d()) {
            output.field_77994_a = output.func_77976_d();
        }
        recipeList.func_77205_a(new MerchantRecipe(inputA, inputB, output));
        ++this.addedRecipes;
        return true;
    }

    protected float safeDivide(int i, float j) {
        return (float)i / Math.max(1.0f, j);
    }

    protected WeightedItemStack getRandomInput(Random random) {
        return WeightedItemStack.getRandomWeightedItemStack(this.allowedTradeInputs, random);
    }

    protected WeightedItemStack getRandomOutput(Random random) {
        return WeightedItemStack.getRandomWeightedItemStack(this.allowedTradeOutputs, random);
    }

    protected int getRandomBetween(Random random, int min, int max) {
        return min + random.nextInt(max - min + 1);
    }
}

