/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.config.extendedconfig;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.core.config.ConfigurableType;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.proxy.ClientProxy;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;

public abstract class EntityConfig
extends ExtendedConfig<EntityConfig> {
    public EntityConfig(boolean enabled, String namedId, String comment, Class<? extends Entity> element) {
        super(enabled, namedId, comment, element);
    }

    @Override
    public String getUnlocalizedName() {
        return "entity." + this.getNamedId();
    }

    @Override
    public ConfigurableType getHolderType() {
        return ConfigurableType.ENTITY;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRegistered() {
        Render render = this.getRender();
        if (render != null) {
            Class clazz = this.getElement();
            ClientProxy.ENTITY_RENDERERS.put(clazz, render);
        }
    }

    public int getTrackingRange() {
        return 160;
    }

    public int getUpdateFrequency() {
        return 10;
    }

    public boolean sendVelocityUpdates() {
        return false;
    }

    protected abstract Render getRender();
}

