/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.config.extendedconfig;

import evilcraft.core.client.render.item.AlphaRenderItem;
import evilcraft.core.config.ConfigurableType;
import evilcraft.core.config.configurable.ConfigurableItem;
import evilcraft.core.config.configurable.IConfigurable;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.core.helper.MinecraftHelpers;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.oredict.OreDictionary;

public abstract class ItemConfig
extends ExtendedConfig<ItemConfig> {
    public ItemConfig(boolean enabled, String namedId, String comment, Class<? extends Item> element) {
        super(enabled, namedId, comment, element);
    }

    @Override
    protected IConfigurable initSubInstance() {
        return this.getElement() == null ? new ConfigurableItem(this) : super.initSubInstance();
    }

    @Override
    public String getUnlocalizedName() {
        return "items." + this.getNamedId();
    }

    @Override
    public String getFullUnlocalizedName() {
        return "item." + this.getUnlocalizedName() + ".name";
    }

    @Override
    public ConfigurableType getHolderType() {
        return ConfigurableType.ITEM;
    }

    public String getOreDictionaryId() {
        return null;
    }

    public boolean blendAlpha() {
        return false;
    }

    public Item getItemInstance() {
        return (Item)super.getSubInstance();
    }

    @Override
    public void onRegistered() {
        if (this.isEnabled()) {
            if (this.blendAlpha() && MinecraftHelpers.isClientSide()) {
                MinecraftForgeClient.registerItemRenderer((Item)this.getItemInstance(), (IItemRenderer)new AlphaRenderItem());
            }
            if (this.getOreDictionaryId() != null) {
                OreDictionary.registerOre((String)this.getOreDictionaryId(), (ItemStack)new ItemStack(this.getItemInstance(), 1, Short.MAX_VALUE));
            }
        }
    }
}

