/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.degradation.effect;

import evilcraft.api.ILocation;
import evilcraft.api.degradation.IDegradable;
import evilcraft.core.config.configurable.ConfigurableDegradationEffect;
import evilcraft.core.config.extendedconfig.DegradationEffectConfig;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.item.MaceOfDistortion;
import java.util.List;
import net.minecraft.entity.Entity;

public class KnockbackDistortDegradation
extends ConfigurableDegradationEffect {
    private static KnockbackDistortDegradation _instance = null;
    private static final int MINIMUM_DEGRADATION = 3;
    private static final int POWER_LEVEL = 1;

    public static void initInstance(ExtendedConfig<DegradationEffectConfig> eConfig) {
        if (_instance == null) {
            _instance = new KnockbackDistortDegradation(eConfig);
        } else {
            eConfig.showDoubleInitError();
        }
    }

    public static KnockbackDistortDegradation getInstance() {
        return _instance;
    }

    private KnockbackDistortDegradation(ExtendedConfig<DegradationEffectConfig> eConfig) {
        super(eConfig);
    }

    @Override
    public boolean canRun(IDegradable degradable) {
        return degradable.getDegradation() >= 3.0;
    }

    @Override
    public void runClientSide(IDegradable degradable) {
    }

    @Override
    public void runServerSide(IDegradable degradable) {
        List<Entity> entities = degradable.getAreaEntities();
        ILocation center = degradable.getLocation();
        double x = center.getCoordinates()[0];
        double y = center.getCoordinates()[1];
        double z = center.getCoordinates()[2];
        for (Entity entity : entities) {
            MaceOfDistortion.getInstance().distortEntity(degradable.getWorld(), null, entity, x, y, z, (int)degradable.getDegradation() * 10, 1);
        }
    }
}

