/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.degradation.effect;

import evilcraft.api.ILocation;
import evilcraft.api.degradation.IDegradable;
import evilcraft.core.config.extendedconfig.DegradationEffectConfig;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.core.degradation.StochasticDegradationEffect;
import evilcraft.core.helper.EntityHelpers;
import evilcraft.core.helper.LocationHelpers;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;

public class MobSpawnDegradation
extends StochasticDegradationEffect {
    private static MobSpawnDegradation _instance = null;
    private static final double CHANCE = 0.01;

    public static void initInstance(ExtendedConfig<DegradationEffectConfig> eConfig) {
        if (_instance == null) {
            _instance = new MobSpawnDegradation(eConfig);
        } else {
            eConfig.showDoubleInitError();
        }
    }

    public static MobSpawnDegradation getInstance() {
        return _instance;
    }

    private MobSpawnDegradation(ExtendedConfig<DegradationEffectConfig> eConfig) {
        super(eConfig, 0.01);
    }

    @Override
    public void runClientSide(IDegradable degradable) {
    }

    @Override
    public void runServerSide(IDegradable degradable) {
        EntityLiving entityliving;
        WorldServer world = (WorldServer)degradable.getWorld();
        ILocation spawn = LocationHelpers.getRandomPointInSphere(degradable.getLocation(), degradable.getRadius());
        float x = (float)spawn.getCoordinates()[0] + 0.5f;
        float y = spawn.getCoordinates()[1];
        float z = (float)spawn.getCoordinates()[2] + 0.5f;
        BiomeGenBase.SpawnListEntry spawnlistentry = world.func_73057_a(EnumCreatureType.monster, spawn.getCoordinates()[0], spawn.getCoordinates()[1], spawn.getCoordinates()[2]);
        try {
            entityliving = (EntityLiving)spawnlistentry.field_76300_b.getConstructor(World.class).newInstance(world);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        entityliving.func_70012_b((double)x, (double)y, (double)z, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        EntityHelpers.spawnEntity((World)world, entityliving);
    }
}

