/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.degradation.effect;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.api.ILocation;
import evilcraft.api.degradation.IDegradable;
import evilcraft.client.particle.EntityDegradeFX;
import evilcraft.core.config.configurable.ConfigurableDegradationEffect;
import evilcraft.core.config.extendedconfig.DegradationEffectConfig;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.world.World;

public class ParticleDegradation
extends ConfigurableDegradationEffect {
    private static ParticleDegradation _instance = null;

    public static void initInstance(ExtendedConfig<DegradationEffectConfig> eConfig) {
        if (_instance == null) {
            _instance = new ParticleDegradation(eConfig);
        } else {
            eConfig.showDoubleInitError();
        }
    }

    public static ParticleDegradation getInstance() {
        return _instance;
    }

    private ParticleDegradation(ExtendedConfig<DegradationEffectConfig> eConfig) {
        super(eConfig);
    }

    @Override
    public boolean canRun(IDegradable degradable) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void runClientSide(IDegradable degradable) {
        ILocation center = degradable.getLocation();
        World world = degradable.getWorld();
        int radius = degradable.getRadius();
        double xCoord = (float)(center.getCoordinates()[0] - radius) + (float)(2 * radius) * world.field_73012_v.nextFloat();
        double yCoord = (float)(center.getCoordinates()[1] - radius) + (float)(2 * radius) * world.field_73012_v.nextFloat();
        double zCoord = (float)(center.getCoordinates()[2] - radius) + (float)(2 * radius) * world.field_73012_v.nextFloat();
        double particleX = xCoord;
        double particleY = yCoord;
        double particleZ = zCoord;
        float particleMotionX = world.field_73012_v.nextFloat() * 1.4f - 0.7f;
        float particleMotionY = -0.2f;
        float particleMotionZ = world.field_73012_v.nextFloat() * 1.4f - 0.7f;
        FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)new EntityDegradeFX(world, particleX, particleY, particleZ, particleMotionX, particleMotionY, particleMotionZ));
    }

    @Override
    public void runServerSide(IDegradable degradable) {
    }
}

