/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.fluid;

import com.google.common.collect.Maps;
import evilcraft.EvilCraft;
import java.util.Map;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.Level;

public class ImplicitFluidConverter {
    private static final String DELIMITER = ":";
    private Fluid target;
    private Map<Fluid, Double> converters = Maps.newHashMap();

    public ImplicitFluidConverter(Fluid target) {
        this.setTarget(target);
    }

    public void setTarget(Fluid target) {
        this.target = target;
        if (target != null) {
            this.converters.put(target, 1.0);
        }
    }

    public Fluid getTarget() {
        return this.target;
    }

    public void addConverter(Fluid fluid, double rate) {
        if (fluid != null) {
            EvilCraft.log("Register fluid conversion for " + fluid.getName() + " with ratio " + rate);
            this.converters.put(fluid, rate);
        }
    }

    public boolean canConvert(Fluid fluid) {
        return this.converters.containsKey(fluid);
    }

    public FluidStack convert(FluidStack fluid) {
        if (fluid != null && this.canConvert(fluid.getFluid())) {
            return new FluidStack(this.target, (int)Math.floor((double)fluid.amount * this.converters.get(fluid.getFluid())));
        }
        return null;
    }

    public FluidStack convertReverse(Fluid target, FluidStack fluid) {
        if (this.canConvert(target) && fluid.getFluid() == this.target) {
            FluidStack ret = fluid.copy();
            return new FluidStack(target, (int)Math.floor((double)ret.amount / this.converters.get(target)));
        }
        return null;
    }

    public double getRatio(Fluid target) {
        return this.converters.get(target);
    }

    public void registerFromConfig(String[] config) {
        for (String line : config) {
            String[] split = line.split(DELIMITER);
            if (split.length != 2) {
                throw new IllegalArgumentException("Invalid line '" + line + "' found for a fluid converter config.");
            }
            Fluid fluid = FluidRegistry.getFluid((String)split[0]);
            if (fluid == null) {
                EvilCraft.log("Could not find a fluid by name '" + split[0] + "' for a fluid converter config.", Level.ERROR);
            }
            double ratio = 1.0;
            try {
                ratio = Double.parseDouble(split[1]);
            }
            catch (NumberFormatException e) {
                EvilCraft.log("Invalid ratio '" + split[1] + "' in a fluid converter config, using 1.0.", Level.ERROR);
            }
            this.addConverter(fluid, ratio);
        }
    }
}

