/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.helper;

import evilcraft.core.IInformationProvider;
import evilcraft.core.helper.MinecraftHelpers;
import evilcraft.core.helper.StringHelpers;
import java.util.List;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;

public final class L10NHelpers {
    private static final int MAX_TOOLTIP_LINE_LENGTH = 25;
    private static final String KEY_ENABLED = "general.info.enabled";
    private static final String KEY_DISABLED = "general.info.disabled";

    public static String localize(String key) {
        return StatCollector.func_74838_a((String)key);
    }

    public static String localize(String key, Object ... params) {
        return StatCollector.func_74837_a((String)key, (Object[])params);
    }

    public static void addStatusInfo(List<String> infoLines, boolean isEnabled, String statusPrefixKey) {
        String autoSupply = EnumChatFormatting.RESET + L10NHelpers.localize(KEY_DISABLED);
        if (isEnabled) {
            autoSupply = EnumChatFormatting.GREEN + L10NHelpers.localize(KEY_ENABLED);
        }
        infoLines.add(EnumChatFormatting.BOLD + L10NHelpers.localize(statusPrefixKey, autoSupply));
    }

    public static String getLocalizedEntityName(String entityId) {
        return L10NHelpers.localize("entity." + entityId + ".name");
    }

    public static void addOptionalInfo(List list, String prefix) {
        String key = prefix + ".info";
        if (StatCollector.func_94522_b((String)key)) {
            if (MinecraftHelpers.isShifted()) {
                String localized = L10NHelpers.localize(key);
                list.addAll(StringHelpers.splitLines(localized, 25, IInformationProvider.INFO_PREFIX));
            } else {
                list.add(L10NHelpers.localize(EnumChatFormatting.GRAY.toString() + EnumChatFormatting.ITALIC.toString() + L10NHelpers.localize("general.tooltip.info")));
            }
        }
    }
}

