/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.helper;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.core.config.configurable.ConfigurableBlockContainer;
import evilcraft.core.helper.InventoryHelpers;
import evilcraft.core.item.TileEntityNBTStorage;
import evilcraft.core.tileentity.EvilCraftTileEntity;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.input.Keyboard;

public class MinecraftHelpers {
    public static final int MINECRAFT_DAY = 24000;
    public static final int COMPARATOR_MULTIPLIER = 15;
    public static final int SECOND_IN_TICKS = 20;
    public static final int BLOCK_NOTIFY = 1;
    public static final int BLOCK_NOTIFY_CLIENT = 2;
    public static final int BLOCK_NOTIFY_NO_RERENDER = 4;
    public static List<String> CHESTGENCATEGORIES = new LinkedList<String>();

    public static boolean isDay(World world) {
        return world.func_72820_D() % 24000L < 12000L;
    }

    public static void setDay(World world, boolean toDay) {
        int currentTime = (int)world.func_72820_D();
        int newTime = currentTime - currentTime % 12000 + 12000;
        world.func_72877_b((long)newTime);
    }

    public static Entity spawnCreature(World world, int entityID, double x, double y, double z) {
        if (!EntityList.field_75627_a.containsKey(entityID)) {
            return null;
        }
        Entity entity = EntityList.func_75616_a((int)entityID, (World)world);
        if (entity != null && entity.func_70089_S()) {
            EntityLiving entityliving = (EntityLiving)entity;
            entity.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
            entityliving.field_70759_as = entityliving.field_70177_z;
            entityliving.field_70761_aq = entityliving.field_70177_z;
            entityliving.func_110161_a((IEntityLivingData)null);
            world.func_72838_d(entity);
            entityliving.func_70642_aH();
        }
        return entity;
    }

    public static void preDestroyBlock(ConfigurableBlockContainer block, World world, int x, int y, int z, boolean saveNBT) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IInventory && !world.field_72995_K) {
            MinecraftHelpers.dropItems(world, (IInventory)tile, x, y, z);
            InventoryHelpers.clearInventory((IInventory)tile);
        }
        if (tile instanceof EvilCraftTileEntity && saveNBT) {
            EvilCraftTileEntity ecTile = (EvilCraftTileEntity)tile;
            TileEntityNBTStorage.TAG = ecTile.getNBTTagCompound();
            block.writeAdditionalInfo(tile, TileEntityNBTStorage.TAG);
            ecTile.destroy();
        } else {
            TileEntityNBTStorage.TAG = null;
        }
    }

    public static void postDestroyBlock(World world, int x, int y, int z) {
    }

    public static void dropItems(World world, ItemStack stack, int x, int y, int z) {
        if (stack.field_77994_a > 0) {
            float offsetMultiply = 0.7f;
            double offsetX = (double)(world.field_73012_v.nextFloat() * offsetMultiply) + (double)(1.0f - offsetMultiply) * 0.5;
            double offsetY = (double)(world.field_73012_v.nextFloat() * offsetMultiply) + (double)(1.0f - offsetMultiply) * 0.5;
            double offsetZ = (double)(world.field_73012_v.nextFloat() * offsetMultiply) + (double)(1.0f - offsetMultiply) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)x + offsetX, (double)y + offsetY, (double)z + offsetZ, stack);
            entityitem.field_145804_b = 10;
            world.func_72838_d((Entity)entityitem);
        }
    }

    public static void dropItems(World world, IInventory inventory, int x, int y, int z) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemStack = inventory.func_70301_a(i);
            if (itemStack == null || itemStack.field_77994_a <= 0) continue;
            MinecraftHelpers.dropItems(world, inventory.func_70301_a(i).func_77946_l(), x, y, z);
        }
    }

    public static boolean isPlayerInventoryFull(EntityPlayer player) {
        return player.field_71071_by.func_70447_i() == -1;
    }

    public static boolean isClientSide() {
        return FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT;
    }

    public static boolean isFluidAndAmountEqual(FluidStack fluid1, FluidStack fluid2) {
        if (fluid1 == null && fluid2 != null || fluid1 != null && fluid2 == null) {
            return false;
        }
        if (fluid1 == null) {
            return true;
        }
        return fluid1.getFluidID() == fluid2.getFluidID() && fluid1.amount == fluid2.amount;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isShifted() {
        return Keyboard.isKeyDown((int)54) || Keyboard.isKeyDown((int)42);
    }

    static {
        CHESTGENCATEGORIES.add("bonusChest");
        CHESTGENCATEGORIES.add("dungeonChest");
        CHESTGENCATEGORIES.add("mineshaftCorridor");
        CHESTGENCATEGORIES.add("pyramidDesertyChest");
        CHESTGENCATEGORIES.add("pyramidJungleChest");
        CHESTGENCATEGORIES.add("pyramidJungleDispenser");
        CHESTGENCATEGORIES.add("strongholdCorridor");
        CHESTGENCATEGORIES.add("strongholdCrossing");
        CHESTGENCATEGORIES.add("strongholdLibrary");
        CHESTGENCATEGORIES.add("villageBlacksmith");
    }

    public static enum NBTTag_Types {
        NBTTagEnd,
        NBTTagByte,
        NBTTagShort,
        NBTTagInt,
        NBTTagLong,
        NBTTagFloat,
        NBTTagDouble,
        NBTTagByteArray,
        NBTTagString,
        NBTTagList,
        NBTTagCompound,
        NBTTagIntArray;

    }
}

