/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.helper;

import evilcraft.core.helper.obfuscation.ObfuscationHelpers;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Triple;
import org.lwjgl.opengl.GL11;

public class RenderHelpers {
    private static Map<ForgeDirection, String> METHODS_RENDERFACE = new HashMap<ForgeDirection, String>();
    private static Map<ForgeDirection, String> FIELDS_UVROTATE;
    private static Map<ForgeDirection, String> METHODS_RENDERFACE_OBFUSICATED;
    private static Map<ForgeDirection, String> FIELDS_UVROTATE_OBFUSICATED;
    private static int[] ROTATE_UV_ROTATE;
    public static IIcon EMPTYICON;

    public static void renderFaceDirection(ForgeDirection renderDirection, RenderBlocks renderer, Block block, double x, double y, double z, IIcon blockIconFromSideAndMetadata) {
        try {
            Method method = ObfuscationHelpers.getRenderFaceMethod(renderer, renderDirection);
            method.invoke((Object)renderer, block, x, y, z, blockIconFromSideAndMetadata);
        }
        catch (SecurityException e2) {
            e2.printStackTrace();
        }
        catch (IllegalAccessException e3) {
            e3.printStackTrace();
        }
        catch (IllegalArgumentException e4) {
            e4.printStackTrace();
        }
        catch (InvocationTargetException e5) {
            e5.printStackTrace();
        }
    }

    public static void setRenderBlocksUVRotation(RenderBlocks renderer, ForgeDirection side, int rotation) {
        ObfuscationHelpers.setUVRotate(renderer, side, ROTATE_UV_ROTATE[rotation]);
    }

    public static void bindTexture(ResourceLocation texture) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
    }

    public static int RGBToInt(int r, int g, int b) {
        return r << 16 | g << 8 | b;
    }

    public static Triple<Float, Float, Float> intToRGB(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        return Triple.of((Object)Float.valueOf(red), (Object)Float.valueOf(green), (Object)Float.valueOf(blue));
    }

    public static void setInvertedRenderBounds(RenderBlocks renderer, Block block) {
        block.func_149683_g();
        if (!renderer.field_147847_n) {
            renderer.field_147859_h = block.func_149753_y();
            renderer.field_147861_i = block.func_149704_x();
            renderer.field_147855_j = block.func_149669_A();
            renderer.field_147857_k = block.func_149665_z();
            renderer.field_147851_l = block.func_149693_C();
            renderer.field_147853_m = block.func_149706_B();
            renderer.field_147849_o = renderer.field_147877_p.field_71474_y.field_74348_k >= 2 && (renderer.field_147859_h > 0.0 || renderer.field_147861_i < 1.0 || renderer.field_147855_j > 0.0 || renderer.field_147857_k < 1.0 || renderer.field_147851_l > 0.0 || renderer.field_147853_m < 1.0);
        }
    }

    public static IIcon getFluidIcon(FluidStack fluid, ForgeDirection side) {
        IIcon icon;
        Block defaultBlock;
        Block block = defaultBlock = Blocks.field_150355_j;
        if (fluid.getFluid().getBlock() != null) {
            block = fluid.getFluid().getBlock();
        }
        if (side == null) {
            side = ForgeDirection.UP;
        }
        if ((icon = fluid.getFluid().getFlowingIcon()) == null || side == ForgeDirection.UP || side == ForgeDirection.DOWN) {
            icon = fluid.getFluid().getStillIcon();
        }
        if (icon == null && (icon = block.func_149691_a(side.ordinal(), 0)) == null) {
            icon = defaultBlock.func_149691_a(side.ordinal(), 0);
        }
        return icon;
    }

    public static void renderFluidContext(FluidStack fluid, double x, double y, double z, IFluidContextRender render) {
        RenderHelpers.renderFluidContext(fluid, x, y, z, true, render);
    }

    public static void renderFluidContext(FluidStack fluid, double x, double y, double z, boolean enableAlpha, IFluidContextRender render) {
        if (fluid != null && fluid.amount > 0) {
            GL11.glPushMatrix();
            GL11.glDepthMask((boolean)true);
            GL11.glDisable((int)2884);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            if (enableAlpha) {
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
            }
            GL11.glTranslated((double)x, (double)y, (double)z);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            render.renderFluid(fluid);
            GL11.glEnable((int)2896);
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        }
    }

    public static void renderTileFluidContext(FluidStack fluid, double x, double y, double z, TileEntity tile, IFluidContextRender render) {
        RenderHelpers.renderTileFluidContext(fluid, x, y, z, true, tile, render);
    }

    public static void renderTileFluidContext(FluidStack fluid, final double x, final double y, final double z, boolean enableAlpha, final TileEntity tile, final IFluidContextRender render) {
        RenderHelpers.renderFluidContext(fluid, x, y, z, enableAlpha, new IFluidContextRender(){

            @Override
            public void renderFluid(FluidStack fluid) {
                Block block = tile.func_145831_w().func_147439_a((int)x, (int)y, (int)z);
                Tessellator.field_78398_a.func_78380_c(2 * block.func_149677_c((IBlockAccess)tile.func_145831_w(), (int)x, (int)y, (int)z));
                render.renderFluid(fluid);
            }
        });
    }

    static {
        METHODS_RENDERFACE.put(ForgeDirection.DOWN, "renderFaceYNeg");
        METHODS_RENDERFACE.put(ForgeDirection.UP, "renderFaceYPos");
        METHODS_RENDERFACE.put(ForgeDirection.NORTH, "renderFaceZPos");
        METHODS_RENDERFACE.put(ForgeDirection.EAST, "renderFaceXPos");
        METHODS_RENDERFACE.put(ForgeDirection.SOUTH, "renderFaceZNeg");
        METHODS_RENDERFACE.put(ForgeDirection.WEST, "renderFaceXNeg");
        FIELDS_UVROTATE = new HashMap<ForgeDirection, String>();
        FIELDS_UVROTATE.put(ForgeDirection.DOWN, "uvRotateBottom");
        FIELDS_UVROTATE.put(ForgeDirection.UP, "uvRotateTop");
        FIELDS_UVROTATE.put(ForgeDirection.NORTH, "uvRotateEast");
        FIELDS_UVROTATE.put(ForgeDirection.EAST, "uvRotateSouth");
        FIELDS_UVROTATE.put(ForgeDirection.SOUTH, "uvRotateWest");
        FIELDS_UVROTATE.put(ForgeDirection.WEST, "uvRotateNorth");
        METHODS_RENDERFACE_OBFUSICATED = new HashMap<ForgeDirection, String>();
        METHODS_RENDERFACE_OBFUSICATED.put(ForgeDirection.DOWN, "func_147768_a");
        METHODS_RENDERFACE_OBFUSICATED.put(ForgeDirection.UP, "func_147806_b");
        METHODS_RENDERFACE_OBFUSICATED.put(ForgeDirection.NORTH, "func_147734_d");
        METHODS_RENDERFACE_OBFUSICATED.put(ForgeDirection.EAST, "func_147764_f");
        METHODS_RENDERFACE_OBFUSICATED.put(ForgeDirection.SOUTH, "func_147761_c");
        METHODS_RENDERFACE_OBFUSICATED.put(ForgeDirection.WEST, "func_147798_e");
        FIELDS_UVROTATE_OBFUSICATED = new HashMap<ForgeDirection, String>();
        FIELDS_UVROTATE_OBFUSICATED.put(ForgeDirection.DOWN, "field_147865_v");
        FIELDS_UVROTATE_OBFUSICATED.put(ForgeDirection.UP, "field_147867_u");
        FIELDS_UVROTATE_OBFUSICATED.put(ForgeDirection.NORTH, "field_147875_q");
        FIELDS_UVROTATE_OBFUSICATED.put(ForgeDirection.EAST, "field_147871_s");
        FIELDS_UVROTATE_OBFUSICATED.put(ForgeDirection.SOUTH, "field_147873_r");
        FIELDS_UVROTATE_OBFUSICATED.put(ForgeDirection.WEST, "field_147869_t");
        ROTATE_UV_ROTATE = new int[]{0, 1, 3, 2};
    }

    public static interface IFluidContextRender {
        public void renderFluid(FluidStack var1);
    }
}

