/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.helper;

import evilcraft.api.ILocation;
import evilcraft.core.algorithm.Location;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;

public class WorldHelpers {
    public static final int CHUNK_SIZE = 16;
    private static final double TICK_LAG_REDUCTION_MODULUS_MODIFIER = 1.0;

    public static void setBiome(World world, int x, int z, BiomeGenBase biome) {
        Chunk chunk = world.func_72938_d(x, z);
        if (chunk != null) {
            int[] c = WorldHelpers.getChunkLocationFromWorldLocation(x, 0, z).getCoordinates();
            int rx = c[0];
            int rz = c[2];
            byte[] biomeArray = chunk.func_76605_m();
            biomeArray[rz << 4 | rx] = (byte)(biome.field_76756_M & 0xFF);
            chunk.func_76630_e();
            world.func_72863_F().func_73158_c(chunk.field_76635_g, chunk.field_76647_h);
            for (EntityPlayerMP player : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
                List chunks = player.field_71129_f;
                chunks.add(new ChunkCoordIntPair(chunk.field_76635_g, chunk.field_76647_h));
            }
        }
    }

    public static boolean efficientTick(World world, int baseModulus, int ... params) {
        int mod = (int)((double)baseModulus * 1.0);
        if (mod == 0) {
            mod = 1;
        }
        int offset = 0;
        for (int param : params) {
            offset += param;
        }
        return world.field_73012_v.nextInt(mod) == Math.abs(offset) % mod;
    }

    public static ILocation getChunkLocationFromWorldLocation(int x, int y, int z) {
        return new Location(x & 0xF, y, z & 0xF);
    }

    public static <T> T foldArea(World world, int area, int x, int y, int z, WorldFoldingFunction<T, T> folder, T value) {
        for (int xc = x - area; xc <= x + area; ++xc) {
            for (int yc = y - area; yc <= y + area; ++yc) {
                for (int zc = z - area; zc <= z + area; ++zc) {
                    value = folder.apply(value, world, xc, yc, zc);
                }
            }
        }
        return value;
    }

    public static interface WorldFoldingFunction<F, T> {
        @Nullable
        public T apply(@Nullable F var1, World var2, int var3, int var4, int var5);
    }
}

