/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.inventory.container;

import evilcraft.core.inventory.slot.SlotArmor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public abstract class InventoryContainer
extends Container {
    protected static final int ITEMBOX = 18;
    private IInventory playerIInventory;
    protected int offsetX = 0;
    protected int offsetY = 0;

    public InventoryContainer(InventoryPlayer inventory) {
        this.playerIInventory = inventory;
    }

    protected Slot createNewSlot(IInventory inventory, int index, int x, int y) {
        return new Slot(inventory, index, x, y);
    }

    protected Slot func_75146_a(Slot slot) {
        slot.field_75223_e += this.offsetX;
        slot.field_75221_f += this.offsetY;
        return super.func_75146_a(slot);
    }

    protected void addInventory(IInventory inventory, int indexOffset, int offsetX, int offsetY, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            for (int x = 0; x < cols; ++x) {
                this.func_75146_a(this.createNewSlot(inventory, x + y * cols + indexOffset, offsetX + x * 18, offsetY + y * 18));
            }
        }
    }

    protected void addPlayerInventory(InventoryPlayer inventory, int offsetX, int offsetY) {
        int rows = 3;
        int cols = 9;
        this.addInventory((IInventory)inventory, cols, offsetX, offsetY, rows, cols);
        this.addInventory((IInventory)inventory, 0, offsetX, offsetY += 58, 1, cols);
    }

    protected void addPlayerArmorInventory(InventoryPlayer inventory, int offsetX, int offsetY) {
        for (int y = 0; y < 4; ++y) {
            this.func_75146_a(new SlotArmor((IInventory)inventory, 36 + (3 - y), offsetX, offsetY + y * 18, inventory.field_70458_d, y));
        }
    }

    protected abstract int getSizeInventory();

    protected int getSlotStart(int originSlot, int slotStart, boolean reverse) {
        return slotStart;
    }

    protected int getSlotRange(int originSlot, int slotRange, boolean reverse) {
        return slotRange;
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotID) {
        ItemStack stack = null;
        Slot slot = (Slot)this.field_75151_b.get(slotID);
        int slots = this.getSizeInventory();
        if (slot != null && slot.func_75216_d()) {
            ItemStack stackInSlot = slot.func_75211_c();
            stack = stackInSlot.func_77946_l();
            if (slotID < slots ? !this.func_75135_a(stackInSlot, this.getSlotStart(slotID, slots, true), this.getSlotRange(slotID, this.field_75151_b.size(), true), true) : !this.func_75135_a(stackInSlot, this.getSlotStart(slotID, 0, false), this.getSlotRange(slotID, slots, false), false)) {
                return null;
            }
            if (stackInSlot.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (stackInSlot.field_77994_a == stack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(player, stackInSlot);
        }
        return stack;
    }

    protected boolean func_75135_a(ItemStack stack, int slotStart, int slotRange, boolean reverse) {
        ItemStack existingStack;
        Slot slot;
        boolean successful = false;
        int slotIndex = slotStart;
        int maxStack = stack.func_77976_d();
        if (reverse) {
            slotIndex = slotRange - 1;
        }
        if (stack.func_77985_e()) {
            while (stack.field_77994_a > 0 && (!reverse && slotIndex < slotRange || reverse && slotIndex >= slotStart)) {
                slot = (Slot)this.field_75151_b.get(slotIndex);
                int maxSlotSize = Math.min(slot.func_75219_a(), maxStack);
                existingStack = slot.func_75211_c();
                if (slot.func_75214_a(stack) && existingStack != null && existingStack.func_77973_b() == stack.func_77973_b() && (!stack.func_77981_g() || stack.func_77960_j() == existingStack.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)existingStack)) {
                    int existingSize = existingStack.field_77994_a + stack.field_77994_a;
                    if (existingSize <= maxSlotSize) {
                        stack.field_77994_a = 0;
                        existingStack.field_77994_a = existingSize;
                        slot.func_75218_e();
                        successful = true;
                    } else if (existingStack.field_77994_a < maxSlotSize) {
                        stack.field_77994_a -= maxSlotSize - existingStack.field_77994_a;
                        existingStack.field_77994_a = maxSlotSize;
                        slot.func_75218_e();
                        successful = true;
                    }
                }
                if (reverse) {
                    --slotIndex;
                    continue;
                }
                ++slotIndex;
            }
        }
        if (stack.field_77994_a > 0) {
            slotIndex = reverse ? slotRange - 1 : slotStart;
            while (!reverse && slotIndex < slotRange || reverse && slotIndex >= slotStart) {
                slot = (Slot)this.field_75151_b.get(slotIndex);
                existingStack = slot.func_75211_c();
                if (slot.func_75214_a(stack) && existingStack == null) {
                    int placedAmount = Math.min(stack.field_77994_a, slot.func_75219_a());
                    ItemStack toPut = stack.func_77946_l();
                    toPut.field_77994_a = placedAmount;
                    slot.func_75215_d(toPut);
                    slot.func_75218_e();
                    stack.field_77994_a -= placedAmount;
                    successful = true;
                    break;
                }
                if (reverse) {
                    --slotIndex;
                    continue;
                }
                ++slotIndex;
            }
        }
        return successful;
    }

    public IInventory getPlayerIInventory() {
        return this.playerIInventory;
    }

    public ItemStack func_75144_a(int slotId, int arg, int function, EntityPlayer player) {
        ItemStack itemStack = super.func_75144_a(slotId, arg, function, player);
        if (arg == 0 && function == 0 && slotId >= 0) {
            this.func_75139_a(slotId).func_75215_d(this.func_75139_a(slotId).func_75211_c());
        }
        return itemStack;
    }
}

