/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.core.IInformationProvider;
import evilcraft.core.item.DamageIndicatedItemComponent;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.ItemFluidContainer;

public abstract class DamageIndicatedItemFluidContainer
extends ItemFluidContainer
implements IInformationProvider {
    protected DamageIndicatedItemComponent component;
    protected Fluid fluid;

    public DamageIndicatedItemFluidContainer(int capacity, Fluid fluid) {
        super(0, capacity);
        this.fluid = fluid;
        this.init();
    }

    private void init() {
        this.component = new DamageIndicatedItemComponent(this);
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        FluidStack stack;
        if (container != null && container.field_77990_d != null && container.field_77990_d.func_74775_l("Fluid") != null && (stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.field_77990_d.func_74775_l("Fluid"))) != null && stack.amount <= 0) {
            stack.amount = 0;
            NBTTagCompound fluidTag = container.field_77990_d.func_74775_l("Fluid");
            fluidTag.func_74768_a("Amount", 0);
            return stack;
        }
        FluidStack fluidStack = super.drain(container, maxDrain, doDrain);
        if (container != null && (container.field_77990_d == null || container.field_77990_d.func_74775_l("Fluid") == null)) {
            this.fill(container, new FluidStack(this.fluid, 0), true);
        }
        return fluidStack;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        int capacityOld = this.capacity;
        this.capacity = this.getCapacity(container);
        int filled = super.fill(container, resource, doFill);
        this.capacity = capacityOld;
        return filled;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List itemList) {
        this.component.getSubItems(item, tab, itemList, this.fluid, 0);
    }

    @Override
    public String getInfo(ItemStack itemStack) {
        return this.component.getInfo(itemStack);
    }

    @Override
    public void provideInformation(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        this.component.addInformation(itemStack, entityPlayer, list, par4);
        super.func_77624_a(itemStack, entityPlayer, list, par4);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack itemStack) {
        return this.component.getDurability(itemStack);
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public boolean canDrain(int amount, ItemStack itemStack) {
        FluidStack simulatedDrain = this.drain(itemStack, amount, false);
        return simulatedDrain != null && simulatedDrain.amount == amount;
    }
}

