/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.recipe.custom;

import evilcraft.api.recipes.custom.IRecipeProperties;
import evilcraft.core.recipe.custom.IDurationRecipeProperties;
import java.beans.ConstructorProperties;

public class DurationXpRecipeProperties
implements IRecipeProperties,
IDurationRecipeProperties {
    private final int duration;
    private final float xp;

    @ConstructorProperties(value={"duration", "xp"})
    public DurationXpRecipeProperties(int duration, float xp) {
        this.duration = duration;
        this.xp = xp;
    }

    @Override
    public int getDuration() {
        return this.duration;
    }

    public float getXp() {
        return this.xp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DurationXpRecipeProperties)) {
            return false;
        }
        DurationXpRecipeProperties other = (DurationXpRecipeProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDuration() != other.getDuration()) {
            return false;
        }
        return Float.compare(this.getXp(), other.getXp()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof DurationXpRecipeProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDuration();
        result = result * 59 + Float.floatToIntBits(this.getXp());
        return result;
    }

    public String toString() {
        return "DurationXpRecipeProperties(duration=" + this.getDuration() + ", xp=" + this.getXp() + ")";
    }
}

