/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.recipe.custom;

import evilcraft.api.recipes.custom.IRecipeProperties;
import evilcraft.block.EnvironmentalAccumulatorConfig;
import evilcraft.core.recipe.custom.DurationRecipeProperties;
import evilcraft.core.recipe.custom.IDurationRecipeProperties;
import evilcraft.tileentity.environmentalaccumulator.IEAProcessingFinishedEffect;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;

public class EnvironmentalAccumulatorRecipeProperties
implements IRecipeProperties,
IDurationRecipeProperties {
    private final double processingSpeed;
    private final int cooldownTime;
    private final IEAProcessingFinishedEffect finishedProcessingEffect;
    private final DurationRecipeProperties duration;
    private final IEAResultOverride resultOverride;

    public EnvironmentalAccumulatorRecipeProperties(int duration, int cooldownTime, double processingSpeed, IEAProcessingFinishedEffect finishedProcessingEffect, IEAResultOverride resultOverride) {
        this.duration = new DurationRecipeProperties(duration);
        this.processingSpeed = processingSpeed;
        this.cooldownTime = cooldownTime;
        this.finishedProcessingEffect = finishedProcessingEffect;
        this.resultOverride = resultOverride;
    }

    public EnvironmentalAccumulatorRecipeProperties(int duration, int cooldownTime, double processingSpeed, IEAProcessingFinishedEffect finishedProcessingEffect) {
        this(duration, cooldownTime, processingSpeed, finishedProcessingEffect, new IEAResultOverride(){

            @Override
            public ItemStack getResult(IBlockAccess world, int x, int y, int z, ItemStack originalResult) {
                return originalResult;
            }
        });
    }

    public EnvironmentalAccumulatorRecipeProperties(int duration, int cooldownTime, double processingSpeed) {
        this(duration, cooldownTime, processingSpeed, null);
    }

    public EnvironmentalAccumulatorRecipeProperties(int duration, int cooldownTime) {
        this(duration, cooldownTime, -1.0);
    }

    public EnvironmentalAccumulatorRecipeProperties(int duration) {
        this(duration, -1);
    }

    public EnvironmentalAccumulatorRecipeProperties() {
        this(-1);
    }

    public double getProcessingSpeed() {
        if (this.processingSpeed < 0.0) {
            return EnvironmentalAccumulatorConfig.defaultProcessItemSpeed;
        }
        return this.processingSpeed;
    }

    public int getCooldownTime() {
        if (this.cooldownTime < 0) {
            return EnvironmentalAccumulatorConfig.defaultTickCooldown;
        }
        return this.cooldownTime;
    }

    @Override
    public int getDuration() {
        if (this.duration.getDuration() < 0) {
            return EnvironmentalAccumulatorConfig.defaultProcessItemTickCount;
        }
        return this.duration.getDuration();
    }

    public IEAProcessingFinishedEffect getFinishedProcessingEffect() {
        return this.finishedProcessingEffect;
    }

    public IEAResultOverride getResultOverride() {
        return this.resultOverride;
    }

    public static interface IEAResultOverride {
        public ItemStack getResult(IBlockAccess var1, int var2, int var3, int var4, ItemStack var5);
    }
}

