/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.recipe.custom;

import evilcraft.api.recipes.custom.IRecipeInput;
import evilcraft.api.recipes.custom.IRecipeOutput;
import evilcraft.api.recipes.custom.IRecipeProperties;
import evilcraft.core.recipe.custom.FluidStackRecipeComponent;
import evilcraft.core.recipe.custom.IFluidStackRecipeComponent;
import evilcraft.core.recipe.custom.IItemStackRecipeComponent;
import evilcraft.core.recipe.custom.ItemStackRecipeComponent;
import evilcraft.core.recipe.custom.OreDictItemStackRecipeComponent;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ItemAndFluidStackRecipeComponent
implements IRecipeInput,
IRecipeOutput,
IRecipeProperties,
IItemStackRecipeComponent,
IFluidStackRecipeComponent {
    private final ItemStackRecipeComponent itemStack;
    private final FluidStackRecipeComponent fluidStack;

    public ItemAndFluidStackRecipeComponent(ItemStack itemStack, FluidStack fluidStack) {
        this.itemStack = new ItemStackRecipeComponent(itemStack);
        this.fluidStack = new FluidStackRecipeComponent(fluidStack);
    }

    public ItemAndFluidStackRecipeComponent(String key, FluidStack fluidStack) {
        this.itemStack = new OreDictItemStackRecipeComponent(key);
        this.fluidStack = new FluidStackRecipeComponent(fluidStack);
    }

    @Override
    public ItemStack getItemStack() {
        return this.itemStack.getItemStack();
    }

    public List<ItemStack> getItemStacks() {
        return this.itemStack.getItemStacks();
    }

    @Override
    public FluidStack getFluidStack() {
        return this.fluidStack.getFluidStack();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ItemAndFluidStackRecipeComponent)) {
            return false;
        }
        ItemAndFluidStackRecipeComponent that = (ItemAndFluidStackRecipeComponent)o;
        if (!this.fluidStack.equals(that.fluidStack)) {
            return false;
        }
        return this.itemStack.equals(that.itemStack);
    }

    public int hashCode() {
        int result = this.itemStack.hashCode();
        result = 31 * result + this.fluidStack.hashCode();
        return result;
    }
}

