/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.recipe.custom;

import evilcraft.api.RegistryManager;
import evilcraft.api.recipes.custom.IMachine;
import evilcraft.api.recipes.custom.IRecipe;
import evilcraft.api.recipes.custom.IRecipeInput;
import evilcraft.api.recipes.custom.IRecipeMatcher;
import evilcraft.api.recipes.custom.IRecipeOutput;
import evilcraft.api.recipes.custom.IRecipeProperties;
import evilcraft.api.recipes.custom.IRecipeRegistry;
import evilcraft.api.recipes.custom.ISuperRecipeRegistry;
import evilcraft.core.recipe.custom.Recipe;
import evilcraft.core.recipe.custom.RecipeMatcher;
import evilcraft.core.recipe.custom.RecipePropertyMatcher;
import java.util.ArrayList;
import java.util.List;

public class RecipeRegistry<M extends IMachine<M, I, O, P>, I extends IRecipeInput, O extends IRecipeOutput, P extends IRecipeProperties>
implements IRecipeRegistry<M, I, O, P> {
    private final M machine;

    public RecipeRegistry(M machine) {
        this.machine = machine;
    }

    @Override
    public void registerRecipe(IRecipe<I, O, P> recipe) {
        RegistryManager.getRegistry(ISuperRecipeRegistry.class).getRecipes((IMachine)this.machine).add(recipe);
    }

    @Override
    public void registerRecipe(String namedId, I input, O output, P properties) {
        this.registerRecipe(new Recipe<I, O, P>(namedId, input, output, properties));
    }

    @Override
    public void registerRecipe(I input, O output, P properties) {
        this.registerRecipe(new Recipe<I, O, P>(input, output, properties));
    }

    @Override
    public IRecipe<I, O, P> findRecipeByNamedId(String namedId) {
        return this.findRecipe(new RecipePropertyMatcher<M, IRecipe<I, O, P>, String>(namedId){

            @Override
            public String getProperty(M machine, IRecipe<I, O, P> recipe) {
                return recipe.getNamedId();
            }
        });
    }

    @Override
    public IRecipe<I, O, P> findRecipeByInput(I input) {
        return this.findRecipe(new RecipePropertyMatcher<M, IRecipe<I, O, P>, I>((IRecipeInput)input){

            @Override
            public I getProperty(M machine, IRecipe<I, O, P> recipe) {
                return recipe.getInput();
            }
        });
    }

    @Override
    public List<IRecipe<I, O, P>> findRecipesByInput(I input) {
        return this.findRecipes(new RecipePropertyMatcher<M, IRecipe<I, O, P>, I>((IRecipeInput)input){

            @Override
            public I getProperty(M machine, IRecipe<I, O, P> recipe) {
                return recipe.getInput();
            }
        });
    }

    @Override
    public IRecipe<I, O, P> findRecipeByOutput(O output) {
        return this.findRecipe(new RecipePropertyMatcher<M, IRecipe<I, O, P>, O>((IRecipeOutput)output){

            @Override
            public O getProperty(M machine, IRecipe<I, O, P> recipe) {
                return recipe.getOutput();
            }
        });
    }

    @Override
    public List<IRecipe<I, O, P>> findRecipesByOutput(O output) {
        return this.findRecipes(new RecipePropertyMatcher<M, IRecipe<I, O, P>, O>((IRecipeOutput)output){

            @Override
            public O getProperty(M machine, IRecipe<I, O, P> recipe) {
                return recipe.getOutput();
            }
        });
    }

    @Override
    public IRecipe<I, O, P> findRecipe(IRecipeMatcher<M, IRecipe<I, O, P>> recipeMatcher) {
        for (IRecipe r : RegistryManager.getRegistry(ISuperRecipeRegistry.class).getRecipes((IMachine)this.machine)) {
            IRecipe recipe = r;
            if (!recipeMatcher.matches(this.machine, recipe)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public List<IRecipe<I, O, P>> findRecipes(IRecipeMatcher<M, IRecipe<I, O, P>> recipeMatcher) {
        ArrayList<IRecipe<I, O, P>> results = new ArrayList<IRecipe<I, O, P>>();
        for (IRecipe r : RegistryManager.getRegistry(ISuperRecipeRegistry.class).getRecipes((IMachine)this.machine)) {
            IRecipe recipe = r;
            if (!recipeMatcher.matches(this.machine, recipe)) continue;
            results.add(recipe);
        }
        return results;
    }

    @Override
    public List<IRecipe<I, O, P>> allRecipes() {
        return this.findRecipes(new RecipeMatcher<M, IRecipe<I, O, P>>(){

            @Override
            public boolean matches(IMachine machine, IRecipe recipeToMatch) {
                return true;
            }
        });
    }
}

