/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.recipe.custom;

import evilcraft.api.recipes.custom.IMachine;
import evilcraft.api.recipes.custom.IRecipe;
import evilcraft.api.recipes.custom.IRecipeInput;
import evilcraft.api.recipes.custom.IRecipeMatch;
import evilcraft.api.recipes.custom.IRecipeMatcher;
import evilcraft.api.recipes.custom.IRecipeOutput;
import evilcraft.api.recipes.custom.IRecipeProperties;
import evilcraft.api.recipes.custom.ISuperRecipeRegistry;
import evilcraft.core.recipe.custom.RecipeMatch;
import evilcraft.core.recipe.custom.RecipePropertyMatcher;
import evilcraft.core.recipe.custom.RecipeRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SuperRecipeRegistry
implements ISuperRecipeRegistry {
    private static final Map<IMachine, List<IRecipe>> recipes = new HashMap<IMachine, List<IRecipe>>();
    private static final Map<IMachine, RecipeRegistry> registries = new HashMap<IMachine, RecipeRegistry>();

    public <M extends IMachine<M, I, O, P>, I extends IRecipeInput, O extends IRecipeOutput, P extends IRecipeProperties> RecipeRegistry<M, I, O, P> getRecipeRegistry(M machine) {
        RecipeRegistry registry = registries.get(machine);
        if (registry == null) {
            registry = new RecipeRegistry(machine);
            registries.put(machine, registry);
        }
        return registry;
    }

    @Override
    public List<IRecipe> getRecipes(IMachine machine) {
        List<IRecipe> list = recipes.get(machine);
        if (list == null) {
            list = new ArrayList<IRecipe>();
            recipes.put(machine, list);
        }
        return list;
    }

    @Override
    public IRecipeMatch<IMachine, IRecipe> findRecipeByNamedId(String namedId) {
        return new RecipePropertyMatcher<IMachine, IRecipe, String>(namedId){

            @Override
            public String getProperty(IMachine machine, IRecipe recipe) {
                return recipe.getNamedId();
            }
        }.findRecipe();
    }

    @Override
    public List<IRecipeMatch<IMachine, IRecipe>> findRecipesByInput(IRecipeInput input) {
        return new RecipePropertyMatcher<IMachine, IRecipe, IRecipeInput>(input){

            @Override
            public IRecipeInput getProperty(IMachine machine, IRecipe recipe) {
                return recipe.getInput();
            }
        }.findRecipes();
    }

    @Override
    public List<IRecipeMatch<IMachine, IRecipe>> findRecipesByMachine(IMachine machine) {
        ArrayList<IRecipeMatch<IMachine, IRecipe>> list = new ArrayList<IRecipeMatch<IMachine, IRecipe>>();
        for (IRecipe recipe : this.getRecipes(machine)) {
            list.add(new RecipeMatch<IMachine, IRecipe>(machine, recipe));
        }
        return list;
    }

    public <M extends IMachine, R extends IRecipe> RecipeMatch<M, R> findRecipe(IRecipeMatcher<M, R> recipeMatcher) {
        for (Map.Entry<IMachine, List<IRecipe>> entry : recipes.entrySet()) {
            IMachine machine = entry.getKey();
            List<IRecipe> recipes = entry.getValue();
            for (IRecipe recipe : recipes) {
                if (!recipeMatcher.matches(machine, recipe)) continue;
                return new RecipeMatch<IMachine, IRecipe>(machine, recipe);
            }
        }
        return null;
    }

    @Override
    public <M extends IMachine, R extends IRecipe> List<IRecipeMatch<M, R>> findRecipes(IRecipeMatcher<M, R> recipeMatcher) {
        ArrayList<IRecipeMatch<M, R>> results = new ArrayList<IRecipeMatch<M, R>>();
        for (Map.Entry<IMachine, List<IRecipe>> entry : recipes.entrySet()) {
            IMachine machine = entry.getKey();
            List<IRecipe> recipes = entry.getValue();
            for (IRecipe recipe : recipes) {
                if (!recipeMatcher.matches(machine, recipe)) continue;
                results.add(new RecipeMatch<IMachine, IRecipe>(machine, recipe));
            }
        }
        return results;
    }
}

