/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.tileentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import evilcraft.core.tileentity.TankInventoryTileEntity;
import evilcraft.core.tileentity.TickingTankInventoryTileEntity;
import evilcraft.core.tileentity.upgrade.IUpgradable;
import evilcraft.core.tileentity.upgrade.IUpgradeBehaviour;
import evilcraft.core.tileentity.upgrade.Upgrades;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;

public abstract class WorkingTileEntity<T extends TankInventoryTileEntity, O>
extends TickingTankInventoryTileEntity<T>
implements IUpgradable<T, O> {
    public static final int INVENTORY_SIZE_UPGRADES = 4;
    public static final Upgrades.Upgrade UPGRADE_TIER1 = Upgrades.getUpgrade("tier", 1);
    public static final Upgrades.Upgrade UPGRADE_TIER2 = Upgrades.getUpgrade("tier", 2);
    public static final Upgrades.Upgrade UPGRADE_TIER3 = Upgrades.getUpgrade("tier", 3);
    public static final Upgrades.Upgrade UPGRADE_SPEED = Upgrades.getUpgrade("speed");
    public static final Upgrades.Upgrade UPGRADE_EFFICIENCY = Upgrades.getUpgrade("efficiency");
    private int basicInventorySize;
    private Map<Upgrades.Upgrade, Integer> levels = null;
    protected Map<Upgrades.Upgrade, IUpgradeBehaviour<T, O>> upgradeBehaviour = Maps.newHashMap();

    public WorkingTileEntity(int inventorySize, String inventoryName, int tankSize, String tankName, Fluid acceptedFluid) {
        super(inventorySize + 4, inventoryName, tankSize, tankName, acceptedFluid);
        this.basicInventorySize = inventorySize;
    }

    public abstract boolean canConsume(ItemStack var1);

    public abstract boolean canWork();

    public boolean isWorking() {
        return this.getWorkTick() > 0;
    }

    public boolean isVisuallyWorking() {
        return this.getCurrentState() == 1 && this.canWork();
    }

    public int getWorkTickScaled(int scale) {
        return (int)Math.ceil((float)(this.getWorkTick() + 1) / this.getRequiredWorkTicks() * (float)scale);
    }

    protected abstract int getWorkTicker();

    protected int getWorkTick() {
        return this.getTickers().get(this.getWorkTicker()).getTick();
    }

    protected float getRequiredWorkTicks() {
        return this.getTickers().get(this.getWorkTicker()).getRequiredTicks();
    }

    public void resetWork() {
        this.resetWork(true);
    }

    public void resetWork(boolean hardReset) {
        if (hardReset) {
            this.getTickers().get(this.getWorkTicker()).setTick(0);
            this.getTickers().get(this.getWorkTicker()).setRequiredTicks(0.0f);
        }
    }

    @Override
    public int getNewState() {
        return this.isWorking() ? 1 : 0;
    }

    @Override
    public void onStateChanged() {
        this.sendUpdate();
    }

    protected List<ItemStack> getUpgradeItems() {
        LinkedList itemStacks = Lists.newLinkedList();
        for (int i = this.getBasicInventorySize(); i < this.getBasicInventorySize() + 4; ++i) {
            ItemStack itemStack = this.func_70301_a(i);
            if (itemStack == null) continue;
            itemStacks.add(itemStack);
        }
        return itemStacks;
    }

    public abstract Upgrades.Upgrade getUpgradeType(ItemStack var1);

    public abstract int getUpgradeLevel(ItemStack var1);

    protected void resetUpgradeLevels() {
        this.levels = null;
    }

    protected boolean isUpgradeSlot(int slotId) {
        return slotId >= this.basicInventorySize && slotId < this.basicInventorySize + 4;
    }

    public boolean onUpgradeSlotChanged(int slotId, ItemStack oldItemStack, ItemStack itemStack) {
        if (!ItemStack.func_77989_b((ItemStack)oldItemStack, (ItemStack)itemStack)) {
            this.resetUpgradeLevels();
            this.resetWork();
            return true;
        }
        return false;
    }

    @Override
    public ItemStack func_70298_a(int slotId, int count) {
        ItemStack itemStack = super.func_70298_a(slotId, count);
        if (this.isUpgradeSlot(slotId)) {
            ItemStack oldItemStack = itemStack.func_77946_l();
            oldItemStack.field_77994_a += count;
            this.onUpgradeSlotChanged(slotId, oldItemStack, itemStack);
        }
        return itemStack;
    }

    @Override
    public void func_70299_a(int slotId, ItemStack itemStack) {
        ItemStack oldItemStack = this.func_70301_a(slotId);
        if (oldItemStack != null) {
            oldItemStack = oldItemStack.func_77946_l();
        }
        super.func_70299_a(slotId, itemStack);
        if (this.isUpgradeSlot(slotId)) {
            this.onUpgradeSlotChanged(slotId, oldItemStack, itemStack);
        }
    }

    public Map<Upgrades.Upgrade, Integer> getUpgradeLevels() {
        if (this.levels == null) {
            this.levels = Maps.newHashMap();
            for (ItemStack itemStack : this.getUpgradeItems()) {
                Upgrades.Upgrade upgrade = this.getUpgradeType(itemStack);
                int level = this.getUpgradeLevel(itemStack);
                if (this.levels.containsKey(upgrade)) {
                    level += this.levels.get(upgrade).intValue();
                }
                this.levels.put(upgrade, level);
            }
        }
        return this.levels;
    }

    @Override
    public Map<Upgrades.Upgrade, IUpgradeBehaviour<T, O>> getUpgradeBehaviour() {
        return this.upgradeBehaviour;
    }

    public Set<Upgrades.Upgrade> getUpgrades() {
        return this.getBlock().getConfig().getUpgrades();
    }

    public int getBasicInventorySize() {
        return this.basicInventorySize;
    }
}

