/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.tileentity.upgrade;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import evilcraft.core.config.extendedconfig.BlockConfig;
import evilcraft.core.tileentity.upgrade.IUpgradable;
import evilcraft.core.tileentity.upgrade.IUpgradeBehaviour;
import evilcraft.core.tileentity.upgrade.IUpgradeSensitiveEvent;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class Upgrades {
    private static Map<String, Upgrade> upgradeMap = Maps.newHashMap();

    public static Upgrade getUpgrade(String upgradeId, int tier) {
        Upgrade upgrade = upgradeMap.get(upgradeId + tier);
        if (upgrade == null) {
            upgrade = new Upgrade(upgradeId, tier);
            upgradeMap.put(upgradeId + tier, upgrade);
        }
        return upgrade;
    }

    public static Upgrade getUpgrade(String upgradeId) {
        return Upgrades.getUpgrade(upgradeId, 0);
    }

    public static UpgradeEventType newUpgradeEventType() {
        return new UpgradeEventType();
    }

    public static <T extends IUpgradable<T, O>, O> void sendEvent(T upgradable, IUpgradeSensitiveEvent<O> event) {
        Upgrades.sendEvent(upgradable, event, upgradable.getUpgradeBehaviour().keySet());
    }

    public static <T extends IUpgradable<T, O>, O> void sendEvent(T upgradable, IUpgradeSensitiveEvent<O> event, Upgrade upgrade) {
        Upgrades.sendEvent(upgradable, event, Lists.newArrayList((Object[])new Upgrade[]{upgrade}));
    }

    public static <T extends IUpgradable<T, O>, O> void sendEvent(T upgradable, IUpgradeSensitiveEvent<O> event, Upgrade ... upgrades) {
        Upgrades.sendEvent(upgradable, event, Lists.newArrayList((Object[])upgrades));
    }

    public static <T extends IUpgradable<T, O>, O> void sendEvent(T upgradable, IUpgradeSensitiveEvent<O> event, Collection<Upgrade> upgrades) {
        for (Upgrade upgrade : upgrades) {
            IUpgradeBehaviour<T, O> behaviour = upgradable.getUpgradeBehaviour().get(upgrade);
            int upgradeLevel = behaviour.getUpgradeLevel(upgradable, upgrade);
            if (upgradeLevel <= 0) continue;
            behaviour.applyUpgrade(upgradable, upgrade, upgradeLevel, event);
        }
    }

    public static class UpgradeEventType {
        private UpgradeEventType() {
        }
    }

    public static class Upgrade {
        private String id;
        private int tier;
        private Set<BlockConfig> upgradableInfo;

        private Upgrade(String id, int tier) {
            this.id = id;
            this.tier = tier;
            this.upgradableInfo = Sets.newTreeSet();
        }

        public String getId() {
            return this.id + this.tier;
        }

        public int getTier() {
            return this.tier;
        }

        public void addUpgradableInfo(BlockConfig upgradableInfo) {
            this.upgradableInfo.add(upgradableInfo);
        }

        public Set<BlockConfig> getUpgradables() {
            return this.upgradableInfo;
        }
    }
}

