/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.core.world;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.WorldSavedData;

public class GlobalCounter {
    private static GlobalCounter _instance = null;
    private Map<String, Integer> counters = Maps.newHashMap();

    private GlobalCounter() {
    }

    public static GlobalCounter getInstance() {
        if (_instance == null) {
            _instance = new GlobalCounter();
        }
        return _instance;
    }

    public void readFromNBT(NBTTagCompound tag) {
        if (tag != null) {
            NBTTagList list = tag.func_150295_c("counters", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound subTag = list.func_150305_b(i);
                this.counters.put(subTag.func_74779_i("key"), subTag.func_74762_e("value"));
            }
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<String, Integer> entry : this.counters.entrySet()) {
            NBTTagCompound subTag = new NBTTagCompound();
            subTag.func_74778_a("key", entry.getKey());
            subTag.func_74768_a("value", entry.getValue().intValue());
            list.func_74742_a((NBTBase)subTag);
        }
        tag.func_74782_a("counters", (NBTBase)list);
    }

    public int getNext(String key) {
        int next = 0;
        if (this.counters.containsKey(key)) {
            next = this.counters.get(key);
        }
        this.counters.put(key, next + 1);
        return next;
    }

    public void reset() {
        this.counters = Maps.newHashMap();
    }

    public static class GlobalCounterData
    extends WorldSavedData {
        public static String KEY = "GlobalCounterData";
        public NBTTagCompound tag = new NBTTagCompound();

        public GlobalCounterData(String key) {
            super(key);
        }

        public void func_76184_a(NBTTagCompound tag) {
            this.tag = tag.func_74775_l(KEY);
        }

        public void func_76187_b(NBTTagCompound tag) {
            tag.func_74782_a(KEY, (NBTBase)this.tag);
        }
    }
}

