/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.entity.item;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.Configs;
import evilcraft.api.ILocation;
import evilcraft.client.particle.EntityBlurFX;
import evilcraft.core.algorithm.Location;
import evilcraft.core.algorithm.OrganicSpread;
import evilcraft.core.config.configurable.IConfigurable;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.core.entity.item.EntityThrowable;
import evilcraft.core.helper.RenderHelpers;
import evilcraft.core.helper.WorldHelpers;
import evilcraft.item.BiomeExtract;
import evilcraft.item.BiomeExtractConfig;
import java.util.Random;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import org.apache.commons.lang3.tuple.Triple;

public class EntityBiomeExtract
extends EntityThrowable
implements IConfigurable {
    private static final int ITEMSTACK_INDEX = 15;

    public EntityBiomeExtract(World world) {
        super(world);
    }

    public EntityBiomeExtract(World world, EntityLivingBase entity, int damage) {
        this(world, entity, new ItemStack((Item)(Configs.isEnabled(BiomeExtractConfig.class) ? BiomeExtract.getInstance() : Items.field_151044_h), 1, damage));
    }

    public EntityBiomeExtract(World world, EntityLivingBase entity, ItemStack stack) {
        super(world, entity);
        this.setItemStack(stack);
    }

    protected void func_70184_a(final MovingObjectPosition movingobjectposition) {
        ItemStack itemStack = this.getItemStack();
        final BiomeGenBase biome = BiomeExtract.getInstance().getBiome(itemStack);
        if (biome != null) {
            OrganicSpread spread = new OrganicSpread(this.field_70170_p, 2, 5, new OrganicSpread.IOrganicSpreadable(){

                @Override
                public boolean isDone(World world, ILocation location) {
                    return world.func_72807_a(location.getCoordinates()[0], location.getCoordinates()[1]) == biome;
                }

                @Override
                public void spreadTo(World world, ILocation location) {
                    if (EntityBiomeExtract.this.field_70170_p.field_72995_K) {
                        EntityBiomeExtract.this.showChangedBiome(EntityBiomeExtract.this.field_70170_p, location.getCoordinates()[0], movingobjectposition.field_72312_c, location.getCoordinates()[1], biome.field_76790_z);
                    } else {
                        WorldHelpers.setBiome(EntityBiomeExtract.this.field_70170_p, location.getCoordinates()[0], location.getCoordinates()[1], biome);
                    }
                }
            });
            for (int i = 0; i < 50; ++i) {
                spread.spreadTick(new Location(movingobjectposition.field_72311_b, movingobjectposition.field_72309_d));
            }
        }
        this.field_70170_p.func_72926_e(2002, (int)Math.round(this.field_70165_t), (int)Math.round(this.field_70163_u), (int)Math.round(this.field_70161_v), 16428);
        this.func_70106_y();
    }

    @SideOnly(value=Side.CLIENT)
    private void showChangedBiome(World world, int xStart, int yStart, int zStart, int color) {
        Triple<Float, Float, Float> c = RenderHelpers.intToRGB(color);
        Random rand = world.field_73012_v;
        for (int j = 0; j < 2 + rand.nextInt(5); ++j) {
            float x = (float)xStart + -0.5f + rand.nextFloat();
            float y = (float)yStart + -0.5f + rand.nextFloat();
            float z = (float)zStart + -0.5f + rand.nextFloat();
            float scale = 0.2f - rand.nextFloat() * 0.2f;
            float red = ((Float)c.getLeft()).floatValue() + rand.nextFloat() * 0.1f;
            float green = ((Float)c.getMiddle()).floatValue() + rand.nextFloat() * 0.1f;
            float blue = ((Float)c.getRight()).floatValue() + rand.nextFloat() * 0.1f;
            float ageMultiplier = 10 + rand.nextInt(15);
            double motionX = -0.1f + rand.nextFloat() * 0.2f;
            double motionY = 0.1f + rand.nextFloat() * 0.2f;
            double motionZ = -0.1f + rand.nextFloat() * 0.2f;
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)new EntityBlurFX(world, x, y, z, scale, motionX, motionY, motionZ, red, green, blue, ageMultiplier));
        }
    }

    protected float func_70185_h() {
        return 0.01f;
    }

    protected float func_70182_d() {
        return 1.0f;
    }

    protected float func_70183_g() {
        return 0.0f;
    }

    @Override
    public ItemStack getItemStack() {
        return this.field_70180_af.func_82710_f(15);
    }

    private void setItemStack(ItemStack stack) {
        this.field_70180_af.func_75692_b(15, (Object)stack);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(15, (Object)BiomeExtract.getInstance().createItemStack(null, 1));
    }

    @Override
    public ExtendedConfig<?> getConfig() {
        return null;
    }
}

