/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.entity.item;

import evilcraft.api.ILocation;
import evilcraft.core.algorithm.Location;
import evilcraft.core.helper.LocationHelpers;
import evilcraft.core.helper.MinecraftHelpers;
import evilcraft.entity.item.EntityItemDefinedRotation;
import evilcraft.world.gen.DarkTempleGenerator;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class EntityItemDarkStick
extends EntityItemDefinedRotation {
    private static final int WATCHERID_VALID = 20;
    private static final int WATCHERID_ANGLE = 21;
    private double lastPosX = -1.0;
    private double lastPosY = -1.0;
    private double lastPosZ = -1.0;

    public EntityItemDarkStick(World world, EntityItem original) {
        super(world, original);
    }

    public EntityItemDarkStick(World world) {
        super(world);
    }

    public EntityItemDarkStick(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public EntityItemDarkStick(World world, double x, double y, double z, ItemStack itemStack) {
        super(world, x, y, z, itemStack);
    }

    public void func_70088_a() {
        super.func_70088_a();
        Float angle = MinecraftHelpers.isClientSide() ? null : this.loadRotation();
        this.field_70180_af.func_75682_a(20, (Object)(angle != null ? 1 : 0));
        this.field_70180_af.func_75682_a(21, (Object)Float.valueOf(angle == null ? 0.0f : angle.floatValue()));
    }

    protected boolean hasMoved() {
        boolean moved = Math.abs(this.lastPosX - this.field_70165_t) > (double)0.1f || Math.abs(this.lastPosZ - this.field_70161_v) > (double)0.1f;
        this.lastPosX = this.field_70165_t;
        this.lastPosY = this.field_70163_u;
        this.lastPosZ = this.field_70161_v;
        return moved;
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (!MinecraftHelpers.isClientSide() && this.hasMoved()) {
            Float angle = this.loadRotation();
            this.setValid(angle != null);
            this.setAngle(angle == null ? 0.0f : angle.floatValue());
        }
    }

    private Float loadRotation() {
        ILocation closest = DarkTempleGenerator.getClosestForCoords(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70161_v);
        if (closest != null) {
            closest.getCoordinates()[1] = 0;
            int[] nArray = new int[]{(int)this.field_70165_t, 0, (int)this.field_70161_v};
            double d = LocationHelpers.getDistance(closest, new Location(nArray));
            if (d <= 32.0) {
                return null;
            }
            Location normalized = new Location(closest.getCoordinates()[0] - (int)this.field_70165_t, 0, closest.getCoordinates()[2] - (int)this.field_70161_v);
            double angle = Math.atan2(normalized.getCoordinates()[0], normalized.getCoordinates()[2]) * 180.0 / Math.PI;
            return Float.valueOf((float)angle);
        }
        return null;
    }

    @Override
    protected boolean hasCustomRotation() {
        return this.isValid() && DarkTempleGenerator.canGenerate(this.field_70170_p);
    }

    public float getAngle() {
        return this.field_70180_af.func_111145_d(21);
    }

    protected void setAngle(float angle) {
        this.field_70180_af.func_75692_b(21, (Object)Float.valueOf(angle));
    }

    public boolean isValid() {
        return this.field_70180_af.func_75679_c(20) == 1;
    }

    protected void setValid(boolean valid) {
        this.field_70180_af.func_75692_b(20, (Object)(valid ? 1 : 0));
    }
}

