/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.entity.monster;

import evilcraft.Configs;
import evilcraft.core.config.configurable.IConfigurable;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.entity.monster.PoisonousLibelleConfig;
import evilcraft.item.PoisonSacConfig;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class PoisonousLibelle
extends EntityFlying
implements IConfigurable,
IMob {
    private static final int POISON_DURATION = 2;
    public double targetX;
    public double targetY;
    public double targetZ;
    public float prevAnimTime;
    public float animTime;
    public boolean forceNewTarget;
    private Entity target;
    private static int WINGLENGTH = 4;
    private int wingProgress = 0;
    private boolean wingGoUp = true;
    private static final int MAXHEIGHT = 80;

    public PoisonousLibelle(World world) {
        super(world);
        this.func_70661_as().func_75491_a(true);
        this.func_70105_a(0.5f, 0.45f);
        this.field_70178_ae = false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)new Byte(0));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.0);
    }

    protected Item func_146068_u() {
        if (Configs.isEnabled(PoisonSacConfig.class)) {
            return PoisonSacConfig._instance.getItemInstance();
        }
        return super.func_146068_u();
    }

    protected String func_70639_aQ() {
        return null;
    }

    protected String func_70621_aR() {
        return "mob.bat.hurt1";
    }

    protected String func_70673_aS() {
        return "mob.bat.death";
    }

    protected float func_70599_aP() {
        return 0.2f;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_70636_d() {
        float f;
        if (this.field_70170_p.field_72995_K) {
            f = MathHelper.func_76134_b((float)(this.animTime * (float)Math.PI * 2.0f));
            float f1 = MathHelper.func_76134_b((float)(this.prevAnimTime * (float)Math.PI * 2.0f));
            if (f1 <= -0.3f && f >= -0.3f && this.field_70146_Z.nextInt(45) == 0) {
                this.field_70170_p.func_72980_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, "mob.bat.idle", 0.1f, 0.8f + this.field_70146_Z.nextFloat() * 0.3f, false);
            }
        }
        this.prevAnimTime = this.animTime;
        f = 0.2f / (MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) * 10.0f + 1.0f);
        this.animTime += (f *= (float)Math.pow(2.0, this.field_70181_x));
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70716_bi > 0) {
                double distanceX = this.field_70165_t + (this.field_70709_bj - this.field_70165_t) / (double)this.field_70716_bi;
                double distanceY = this.field_70163_u + (this.field_70710_bk - this.field_70163_u) / (double)this.field_70716_bi;
                double distanceZ = this.field_70161_v + (this.field_110152_bk - this.field_70161_v) / (double)this.field_70716_bi;
                double distance = MathHelper.func_76138_g((double)(this.field_70712_bm - (double)this.field_70177_z));
                this.field_70177_z = (float)((double)this.field_70177_z + distance / (double)this.field_70716_bi);
                this.field_70125_A = (float)((double)this.field_70125_A + (this.field_70705_bn - (double)this.field_70125_A) / (double)this.field_70716_bi);
                --this.field_70716_bi;
                this.func_70107_b(distanceX, distanceY, distanceZ);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            }
        } else {
            double limitDifferenceYaw;
            float limitDistanceY;
            double distanceX = this.targetX - this.field_70165_t;
            double distanceY = this.targetY - this.field_70163_u;
            double distanceZ = this.targetZ - this.field_70161_v;
            double distance = distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ;
            if (this.target != null) {
                this.targetX = this.target.field_70165_t;
                this.targetZ = this.target.field_70161_v;
                double distancedX = this.targetX - this.field_70165_t;
                double distancedZ = this.targetZ - this.field_70161_v;
                double distancedHeightPlane = Math.sqrt(distancedX * distancedX + distancedZ * distancedZ);
                double Yplus = 0.4 + distancedHeightPlane / 80.0 - 1.0;
                if (Yplus > 10.0) {
                    Yplus = 10.0;
                }
                this.targetY = Math.min(this.target.field_70121_D.field_72338_b + Yplus, 80.0);
            } else {
                this.targetX += this.field_70146_Z.nextGaussian() * 2.0;
                this.targetZ += this.field_70146_Z.nextGaussian() * 2.0;
            }
            if (this.forceNewTarget || distance < 3.0 || distance > 250.0 || this.field_70123_F || this.field_70124_G || this.targetY > 80.0) {
                this.setNewTarget();
            }
            if ((distanceY /= (double)MathHelper.func_76133_a((double)(distanceX * distanceX + distanceZ * distanceZ))) < (double)(-(limitDistanceY = 0.6f))) {
                distanceY = -limitDistanceY;
            }
            if (distanceY > (double)limitDistanceY) {
                distanceY = limitDistanceY;
            }
            this.field_70181_x += distanceY * 0.1;
            this.field_70177_z = MathHelper.func_76142_g((float)this.field_70177_z);
            double newYaw = 180.0 - Math.atan2(distanceX, distanceZ) * 180.0 / Math.PI;
            double differenceYaw = MathHelper.func_76138_g((double)(newYaw - (double)this.field_70177_z));
            if (differenceYaw > (limitDifferenceYaw = 50.0)) {
                differenceYaw = limitDifferenceYaw;
            }
            if (differenceYaw < -limitDifferenceYaw) {
                differenceYaw = -limitDifferenceYaw;
            }
            Vec3 distanceVector = Vec3.func_72443_a((double)(this.targetX - this.field_70165_t), (double)(this.targetY - this.field_70163_u), (double)(this.targetZ - this.field_70161_v)).func_72432_b();
            Vec3 rotationVector = Vec3.func_72443_a((double)MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)), (double)this.field_70181_x, (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)))).func_72432_b();
            float dynamicMotionMultiplier = (float)(rotationVector.func_72430_b(distanceVector) + 0.5) / 1.5f;
            if (dynamicMotionMultiplier < 0.0f) {
                dynamicMotionMultiplier = 0.0f;
            }
            this.field_70704_bt *= 0.8f;
            float motionDistanceHeightPlaneFloat = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) * 1.0f + 1.0f;
            double motionDistanceHeightPlane = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y) * 1.0 + 1.0;
            if (motionDistanceHeightPlane > 40.0) {
                motionDistanceHeightPlane = 40.0;
            }
            this.field_70704_bt = (float)((double)this.field_70704_bt + differenceYaw * (0.7 / motionDistanceHeightPlane / (double)motionDistanceHeightPlaneFloat));
            this.field_70177_z += this.field_70704_bt * 0.1f;
            float scaledMotionDistanceHeightPlane = (float)(2.0 / (motionDistanceHeightPlane + 1.0));
            float staticMotionMultiplier = 0.06f;
            this.func_70060_a(0.0f, -1.0f, staticMotionMultiplier * (dynamicMotionMultiplier * scaledMotionDistanceHeightPlane + (1.0f - scaledMotionDistanceHeightPlane)));
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            Vec3 motionVector = Vec3.func_72443_a((double)this.field_70159_w, (double)this.field_70181_x, (double)this.field_70179_y).func_72432_b();
            float motionRotation = (float)(motionVector.func_72430_b(rotationVector) + 1.0) / 2.0f;
            motionRotation = 0.8f + 0.15f * motionRotation;
            this.field_70159_w *= (double)motionRotation;
            this.field_70179_y *= (double)motionRotation;
            this.field_70181_x *= 0.9;
            this.field_70159_w /= 1.5;
            this.field_70181_x /= 1.2;
            this.field_70179_y /= 1.5;
        }
        this.field_70761_aq = this.field_70177_z;
        if (!this.field_70170_p.field_72995_K && this.field_70737_aN == 0 && !this.field_70128_L) {
            this.attackEntitiesInList(this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(1.0, 0.0, 1.0)));
        }
        if (this.wingGoUp) {
            ++this.wingProgress;
            if (this.wingProgress > WINGLENGTH) {
                this.wingGoUp = false;
            }
        } else {
            --this.wingProgress;
            if (this.wingProgress < -WINGLENGTH) {
                this.wingGoUp = true;
            }
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    private void attackEntitiesInList(List<Entity> entities) {
        int chance = PoisonousLibelleConfig.poisonChance;
        for (Entity entity : entities) {
            if (chance <= 0 || this.field_70170_p.field_73012_v.nextInt(chance) != 0 || !(entity instanceof EntityLivingBase)) continue;
            boolean shouldAttack = true;
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
                shouldAttack = false;
                this.setNewTarget();
            }
            if (!shouldAttack) continue;
            if (PoisonousLibelleConfig.hasAttackDamage) {
                entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 0.5f);
            }
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 40, 1));
        }
    }

    private void setNewTarget() {
        this.forceNewTarget = false;
        boolean targetSet = false;
        if (this.field_70146_Z.nextInt(2) == 0 && !this.field_70170_p.field_73010_i.isEmpty() && !this.field_70170_p.func_72935_r()) {
            this.target = (Entity)this.field_70170_p.field_73010_i.get(this.field_70146_Z.nextInt(this.field_70170_p.field_73010_i.size()));
            targetSet = true;
            if (this.target instanceof EntityPlayer && ((EntityPlayer)this.target).field_71075_bZ.field_75098_d) {
                targetSet = false;
            }
        }
        if (!targetSet) {
            double d2;
            double d1;
            double d0;
            boolean flag = false;
            do {
                this.targetX = this.field_70165_t;
                this.targetY = 80.0f - this.field_70146_Z.nextFloat() * 30.0f;
                this.targetZ = this.field_70161_v;
                this.targetX += (double)(this.field_70146_Z.nextFloat() * 120.0f - 60.0f);
                this.targetZ += (double)(this.field_70146_Z.nextFloat() * 120.0f - 60.0f);
            } while (!(flag = (d0 = this.field_70165_t - this.targetX) * d0 + (d1 = this.field_70163_u - this.targetY) * d1 + (d2 = this.field_70161_v - this.targetZ) * d2 > 20.0));
            this.target = null;
        }
    }

    public float getWingProgressScaled(float scale) {
        return (float)this.wingProgress / (float)WINGLENGTH * scale;
    }

    @Override
    public ExtendedConfig<?> getConfig() {
        return null;
    }
}

