/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.entity.monster;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.Configs;
import evilcraft.EvilCraft;
import evilcraft.GeneralConfig;
import evilcraft.block.GemStoneTorchConfig;
import evilcraft.client.particle.EntityBlurFX;
import evilcraft.client.particle.EntityDarkSmokeFX;
import evilcraft.client.particle.EntityDegradeFX;
import evilcraft.core.config.IChangedCallback;
import evilcraft.core.config.configurable.IConfigurable;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.core.entity.monster.EntityNoMob;
import evilcraft.core.helper.L10NHelpers;
import evilcraft.core.helper.WorldHelpers;
import evilcraft.core.helper.obfuscation.ObfuscationHelpers;
import evilcraft.entity.monster.ControlledZombie;
import evilcraft.entity.monster.VengeanceSpiritConfig;
import evilcraft.item.BurningGemStone;
import evilcraft.item.BurningGemStoneConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import thaumcraft.api.ThaumcraftApiHelper;

public class VengeanceSpirit
extends EntityNoMob
implements IConfigurable {
    public static final String DEFAULT_L10N_KEY = "vengeanceSpirit";
    private static final int SWARM_TIERS = 5;
    private static final Set<Class<? extends EntityLivingBase>> BLACKLIST = Sets.newHashSet();
    private static final Set<Class<? extends EntityLivingBase>> IMC_BLACKLIST = Sets.newHashSet();
    public static final int REMAININGLIFE_MIN = 250;
    public static final int REMAININGLIFE_MAX = 1000;
    private static final int WATCHERID_INNER = 20;
    private static final int WATCHERID_REMAININGLIFE = 21;
    private static final int WATCHERID_FROZENDURATION = 22;
    private static final int WATCHERID_GLOBALVENGEANCE = 23;
    private static final int WATCHERID_VENGEANCEPLAYERS = 24;
    private static final int WATCHERID_ISSWARM = 25;
    private static final int WATCHERID_SWARMTIER = 26;
    private static final int WATCHERID_BUILDUP = 27;
    private static final int WATCHERID_PLAYERID = 28;
    private static final int WATCHERID_PLAYERNAME = 29;
    public static final String NBTKEY_INNER_SPIRIT = "innerEntity";
    private EntityLivingBase innerEntity = null;

    public VengeanceSpirit(World world) {
        super(world);
        this.func_70661_as().func_75491_a(false);
        this.field_70138_W = 5.0f;
        this.field_70178_ae = true;
        this.field_70156_m = false;
        this.func_70105_a(1.0f, 1.0f);
        double speed = 0.5;
        double damage = 0.5;
        int remainingLife = MathHelper.func_76136_a((Random)world.field_73012_v, (int)250, (int)1000);
        if (this.isSwarm()) {
            speed += 0.25 * (double)this.getSwarmTier();
            damage += 0.5 * (double)this.getSwarmTier();
            remainingLife += 750 * this.getSwarmTier();
        }
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(speed);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, damage, false));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.setRemainingLife(remainingLife);
        this.setFrozenDuration(0);
    }

    private String getRandomInnerEntity() {
        Class clazz;
        EntityList.EntityEggInfo egg;
        Collection eggs = EntityList.field_75627_a.values();
        ArrayList eggList = Lists.newArrayList(eggs);
        if (eggList.size() > 0 && (egg = (EntityList.EntityEggInfo)eggList.get(this.field_70146_Z.nextInt(eggList.size()))) != null && (clazz = (Class)EntityList.field_75623_d.get(egg.field_75613_a)) != null) {
            return clazz.getName();
        }
        return VengeanceSpirit.class.getName();
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)this.getRandomInnerEntity());
        this.field_70180_af.func_75682_a(21, (Object)0);
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)0);
        this.field_70180_af.func_75682_a(24, (Object)new String());
        this.field_70180_af.func_75682_a(25, (Object)0);
        this.field_70180_af.func_75682_a(26, (Object)this.field_70146_Z.nextInt(5));
        this.field_70180_af.func_75682_a(27, (Object)0);
        this.field_70180_af.func_75682_a(28, (Object)"");
        this.field_70180_af.func_75682_a(29, (Object)"");
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        if (this.getInnerEntity() != null) {
            tag.func_74778_a(NBTKEY_INNER_SPIRIT, this.getInnerEntity().getClass().getName());
        }
        tag.func_74768_a("remainingLife", this.getRemainingLife());
        tag.func_74768_a("frozenDuration", this.getFrozenDuration());
        tag.func_74757_a("isSwarm", this.isSwarm());
        tag.func_74768_a("swarmTier", this.getSwarmTier());
        tag.func_74768_a("buildupDuration", this.getBuildupDuration());
        tag.func_74778_a("playerId", this.getPlayerId());
        tag.func_74778_a("playerName", this.getPlayerName());
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        String name = tag.func_74779_i(NBTKEY_INNER_SPIRIT);
        if (name != null) {
            this.field_70180_af.func_75692_b(20, (Object)name);
        }
        this.setRemainingLife(tag.func_74762_e("remainingLife"));
        this.setFrozenDuration(tag.func_74762_e("frozenDuration"));
        this.setIsSwarm(tag.func_74767_n("isSwarm"));
        this.setSwarmTier(tag.func_74762_e("swarmTier"));
        this.setBuildupDuration(tag.func_74762_e("buildupDuration"));
        this.setPlayerId(tag.func_74779_i("playerId"));
        this.setPlayerName(tag.func_74779_i("playerName"));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    protected float func_70647_i() {
        return super.func_70647_i() / 3.0f;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public boolean func_85032_ar() {
        return true;
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (this.getBuildupDuration() > 0) {
            return false;
        }
        this.func_70106_y();
        this.field_70170_p.func_72900_e((Entity)this);
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (Loader.isModLoaded((String)"Thaumcraft")) {
                this.addWarp((EntityPlayer)entity);
            }
            if (!Configs.isEnabled(BurningGemStoneConfig.class) || BurningGemStone.damageForPlayer(player, this.isSwarm() ? this.getSwarmTier() : 0, false)) {
                entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * 0.01f), 0.025, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * 0.01f));
                entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 0.1f);
                return false;
            }
        }
        return super.func_70652_k(entity);
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.field_70170_p.field_72995_K && this.isVisible()) {
            this.spawnSmoke();
            this.func_85030_a(this.func_70673_aS(), 0.1f + this.field_70170_p.field_73012_v.nextFloat() * 0.9f, 0.1f + this.field_70170_p.field_73012_v.nextFloat() * 0.9f);
        }
    }

    public boolean func_70610_aX() {
        return this.isFrozen() || this.getBuildupDuration() > 0;
    }

    public void func_70636_d() {
        int buildupDuration;
        super.func_70636_d();
        if (this.isVisible()) {
            if (this.innerEntity != null) {
                this.innerEntity.field_70128_L = this.field_70128_L;
                this.innerEntity.field_70725_aQ = this.field_70725_aQ;
                this.innerEntity.field_70724_aR = this.field_70724_aR;
                this.innerEntity.field_70737_aN = this.field_70737_aN;
                this.innerEntity.field_70125_A = this.field_70125_A;
                this.innerEntity.field_70177_z = this.field_70177_z;
                this.innerEntity.field_70759_as = this.field_70759_as;
                this.innerEntity.field_70761_aq = this.field_70761_aq;
                this.innerEntity.field_70726_aT = this.field_70726_aT;
                this.innerEntity.field_70727_aS = this.field_70727_aS;
                this.innerEntity.field_70760_ar = this.field_70760_ar;
                this.innerEntity.field_70127_C = this.field_70127_C;
                this.innerEntity.field_70126_B = this.field_70126_B;
                this.innerEntity.field_70758_at = this.field_70758_at;
            }
            if (this.field_70170_p.field_72995_K) {
                this.spawnSmoke();
                if (this.isSwarm()) {
                    this.spawnSwarmParticles();
                }
            }
        }
        if ((buildupDuration = this.getBuildupDuration()) > 0) {
            this.setBuildupDuration(buildupDuration - 1);
        }
        if (this.isFrozen()) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            this.addFrozenDuration(-1);
        } else {
            this.setRemainingLife(this.getRemainingLife() - 1);
            if (this.getRemainingLife() <= 0) {
                this.func_70106_y();
                this.field_70170_p.func_72900_e((Entity)this);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnSmoke() {
        int numParticles = this.field_70146_Z.nextInt(5);
        if (this.field_70128_L) {
            numParticles *= 10;
        }
        float clearRange = this.field_70130_N;
        for (int i = 0; i < numParticles; ++i) {
            double particleX = this.field_70165_t - (double)(this.field_70130_N / 2.0f) + (double)(this.field_70130_N * this.field_70146_Z.nextFloat());
            if (particleX < (double)0.7f && particleX >= 0.0) {
                particleX += (double)(this.field_70130_N / 2.0f);
            }
            if (particleX > (double)-0.7f && particleX <= 0.0) {
                particleX -= (double)(this.field_70130_N / 2.0f);
            }
            double particleY = this.field_70163_u + (double)(this.field_70131_O * this.field_70146_Z.nextFloat());
            double particleZ = this.field_70161_v - (double)(this.field_70130_N / 2.0f) + (double)(this.field_70130_N * this.field_70146_Z.nextFloat());
            if (particleZ < (double)clearRange && particleZ >= 0.0) {
                particleZ += (double)(this.field_70130_N / 2.0f);
            }
            if (particleZ > (double)(-clearRange) && particleZ <= 0.0) {
                particleZ -= (double)(this.field_70130_N / 2.0f);
            }
            float particleMotionX = (-0.5f + this.field_70146_Z.nextFloat()) * 0.05f;
            float particleMotionY = (-0.5f + this.field_70146_Z.nextFloat()) * 0.05f;
            float particleMotionZ = (-0.5f + this.field_70146_Z.nextFloat()) * 0.05f;
            EntityDarkSmokeFX particle = new EntityDarkSmokeFX(this.field_70170_p, particleX, particleY, particleZ, particleMotionX, particleMotionY, particleMotionZ);
            if (this.field_70128_L) {
                particle.setDeathParticles();
            }
            particle.setLiving((float)this.getRemainingLife() / 1000.0f);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particle);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnSwarmParticles() {
        int numParticles = 5 * (this.field_70146_Z.nextInt((this.getSwarmTier() << 1) + 1) + 1);
        for (int i = 0; i < numParticles; ++i) {
            double particleX = this.field_70165_t - (double)(this.field_70130_N / 2.0f) + (double)(this.field_70130_N * this.field_70146_Z.nextFloat());
            if (particleX < (double)0.7f && particleX >= 0.0) {
                particleX += (double)(this.field_70130_N / 2.0f);
            }
            if (particleX > (double)-0.7f && particleX <= 0.0) {
                particleX -= (double)(this.field_70130_N / 2.0f);
            }
            double particleY = this.field_70163_u + (double)(this.field_70131_O * this.field_70146_Z.nextFloat());
            double particleZ = this.field_70161_v - (double)(this.field_70130_N / 2.0f) + (double)(this.field_70130_N * this.field_70146_Z.nextFloat());
            float particleMotionX = (-0.5f + this.field_70146_Z.nextFloat()) * 0.05f;
            float particleMotionY = (-0.5f + this.field_70146_Z.nextFloat()) * 0.05f;
            float particleMotionZ = (-0.5f + this.field_70146_Z.nextFloat()) * 0.05f;
            EntityDegradeFX particle = new EntityDegradeFX(this.field_70170_p, particleX, particleY, particleZ, particleMotionX, particleMotionY, particleMotionZ);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particle);
        }
    }

    public boolean isVisible() {
        return this.field_70170_p.field_72995_K && (this.isAlternativelyVisible() || this.isClientVisible());
    }

    @SideOnly(value=Side.CLIENT)
    private boolean isClientVisible() {
        return this.isEnabledVengeance((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
    }

    private boolean isAlternativelyVisible() {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        return player != null && player.field_71075_bZ.field_75098_d;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    public void func_70077_a(EntityLightningBolt lightning) {
        this.setGlobalVengeance(true);
    }

    public boolean func_70685_l(Entity entity) {
        if (entity instanceof EntityPlayer) {
            return this.isEnabledVengeance((EntityPlayer)entity);
        }
        return super.func_70685_l(entity);
    }

    public boolean isEnabledVengeance(EntityPlayer player) {
        return this.isGlobalVengeance() || ArrayUtils.contains((Object[])this.getVengeancePlayers(), (Object)player.getDisplayName());
    }

    public void setEnabledVengeance(EntityPlayer player, boolean enabled) {
        Object[] players = this.getVengeancePlayers();
        int index = ArrayUtils.indexOf((Object[])players, (Object)player.getDisplayName());
        if (enabled && index == -1) {
            players = (String[])ArrayUtils.add((Object[])players, (Object)player.getDisplayName());
        } else if (!enabled && index != -1) {
            players = (String[])ArrayUtils.remove((Object[])players, (int)index);
        }
        this.setVengeancePlayers((String[])players);
    }

    public EntityLivingBase getInnerEntity() {
        if (this.isSwarm()) {
            this.field_70131_O = this.getSwarmTier() / 2 + 1;
            this.field_70130_N = this.getSwarmTier() / 3 + 1;
            return null;
        }
        if (this.innerEntity != null) {
            return this.innerEntity;
        }
        try {
            String name;
            Entity entity;
            Class<?> clazz = Class.forName(this.field_70180_af.func_75681_e(20));
            if (!clazz.equals(VengeanceSpirit.class) && VengeanceSpirit.canSustain((EntityLivingBase)(entity = EntityList.func_75620_a((String)(name = (String)EntityList.field_75626_c.get(clazz)), (World)this.field_70170_p)))) {
                this.innerEntity = (EntityLivingBase)entity;
                this.func_70105_a(this.innerEntity.field_70130_N, this.innerEntity.field_70131_O);
                return this.innerEntity;
            }
        }
        catch (ClassNotFoundException clazz) {
        }
        catch (NullPointerException e) {
            EvilCraft.log("Tried to spirit invalid entity, removing it now.", Level.ERROR);
        }
        catch (ClassCastException e) {
            EvilCraft.log("Tried to spirit invalid entity, removing it now.", Level.ERROR);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72900_e((Entity)this);
        }
        return null;
    }

    public void setInnerEntity(EntityLivingBase innerEntity) {
        if (innerEntity instanceof EntityPlayer) {
            this.setPlayerId(((EntityPlayer)innerEntity).func_146103_bH().getId().toString());
            this.setPlayerName(((EntityPlayer)innerEntity).func_146103_bH().getName());
            innerEntity = new EntityZombie(this.field_70170_p);
        }
        this.field_70180_af.func_75692_b(20, (Object)innerEntity.getClass().getName());
    }

    public int getRemainingLife() {
        return this.field_70180_af.func_75679_c(21);
    }

    public void setRemainingLife(int remainingLife) {
        this.field_70180_af.func_75692_b(21, (Object)remainingLife);
    }

    public int getBuildupDuration() {
        return this.field_70180_af.func_75679_c(27);
    }

    public void setBuildupDuration(int buildupDuration) {
        this.field_70180_af.func_75692_b(27, (Object)buildupDuration);
    }

    public String getPlayerId() {
        return this.field_70180_af.func_75681_e(28);
    }

    public UUID getPlayerUUID() {
        try {
            return UUID.fromString(this.getPlayerId());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public boolean func_70684_aJ() {
        return this.getPlayerUUID() != null;
    }

    public void setPlayerId(String playerId) {
        this.field_70180_af.func_75692_b(28, (Object)playerId);
    }

    public String getPlayerName() {
        return this.field_70180_af.func_75681_e(29);
    }

    public void setPlayerName(String playerName) {
        this.field_70180_af.func_75692_b(29, (Object)playerName);
    }

    public int getFrozenDuration() {
        return this.field_70180_af.func_75679_c(22);
    }

    public void setFrozenDuration(int frozenDuration) {
        this.field_70180_af.func_75692_b(22, (Object)frozenDuration);
    }

    public boolean isGlobalVengeance() {
        return this.field_70180_af.func_75679_c(23) == 1;
    }

    public void setGlobalVengeance(boolean globalVengeance) {
        this.field_70180_af.func_75692_b(23, (Object)(globalVengeance ? 1 : 0));
    }

    public boolean isSwarm() {
        return this.field_70180_af.func_75679_c(25) == 1;
    }

    public void setIsSwarm(boolean isSwarm) {
        this.field_70180_af.func_75692_b(25, (Object)(isSwarm ? 1 : 0));
    }

    public int getSwarmTier() {
        return this.field_70180_af.func_75679_c(26);
    }

    public void setSwarmTier(int swarmTier) {
        this.field_70180_af.func_75692_b(26, (Object)swarmTier);
    }

    public String[] getVengeancePlayers() {
        String encodedPlayers = this.field_70180_af.func_75681_e(24);
        if (encodedPlayers.length() == 0) {
            return new String[0];
        }
        return encodedPlayers.split("&");
    }

    public void setVengeancePlayers(String[] vengeancePlayers) {
        this.field_70180_af.func_75692_b(24, (Object)StringUtils.join((Object[])vengeancePlayers, (String)"&"));
    }

    public static boolean canSustain(EntityLivingBase entityLiving) {
        for (Class<? extends EntityLivingBase> clazz : BLACKLIST) {
            if (!clazz.isInstance(entityLiving)) continue;
            return false;
        }
        return true;
    }

    public static boolean canSustainClass(Class<?> entityLivingClazz) {
        for (Class<? extends EntityLivingBase> clazz : BLACKLIST) {
            if (!clazz.equals(entityLivingClazz)) continue;
            return false;
        }
        return true;
    }

    public static boolean canSpawnNew(World world, double x, double y, double z) {
        if (Double.isNaN(x) || Double.isNaN(y) || Double.isNaN(z)) {
            return false;
        }
        int area = VengeanceSpiritConfig.spawnLimitArea;
        int threshold = VengeanceSpiritConfig.spawnLimit;
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)x, (double)y, (double)z).func_72314_b((double)area, (double)area, (double)area);
        List spirits = world.func_72872_a(VengeanceSpirit.class, box);
        if (spirits.size() >= threshold) {
            return false;
        }
        if (!Configs.isEnabled(GemStoneTorchConfig.class)) {
            return true;
        }
        return WorldHelpers.foldArea(world, GemStoneTorchConfig.area, (int)x, (int)y, (int)z, new WorldHelpers.WorldFoldingFunction<Boolean, Boolean>(){

            @Override
            @Nullable
            public Boolean apply(@Nullable Boolean input, World world, int x, int y, int z) {
                return (input == null || input != false) && world.func_147439_a(x, y, z) != GemStoneTorchConfig._instance.getBlockInstance();
            }
        }, true);
    }

    public void addFrozenDuration(int addFrozen) {
        this.setFrozenDuration(this.getFrozenDuration() + addFrozen);
    }

    public boolean isFrozen() {
        return this.getFrozenDuration() > 0;
    }

    public void onHit(double hitX, double hitY, double hitZ, double impactMotionX, double impactMotionY, double impactMotionZ) {
        this.addFrozenDuration(this.field_70170_p.field_73012_v.nextInt(4) + 3);
        if (this.field_70170_p.field_72995_K) {
            this.showBurstParticles(hitX, hitY, hitZ, impactMotionX, impactMotionY, impactMotionZ);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void showBurstParticles(double hitX, double hitY, double hitZ, double impactMotionX, double impactMotionY, double impactMotionZ) {
        for (int i = 0; i < this.field_70170_p.field_73012_v.nextInt(5); ++i) {
            float scale = 0.04f - this.field_70146_Z.nextFloat() * 0.02f;
            float red = this.field_70146_Z.nextFloat() * 0.2f + 0.3f;
            float green = this.field_70146_Z.nextFloat() * 0.2f + 0.3f;
            float blue = this.field_70146_Z.nextFloat() * 0.01f;
            float ageMultiplier = (float)(this.field_70146_Z.nextDouble() * 0.5 + 3.0);
            double dx = 0.1 - this.field_70146_Z.nextDouble() * 0.2 - impactMotionX * 0.1;
            double dy = 0.1 - this.field_70146_Z.nextDouble() * 0.2 - impactMotionY * 0.1;
            double dz = 0.1 - this.field_70146_Z.nextDouble() * 0.2 - impactMotionZ * 0.1;
            EntityBlurFX blur = new EntityBlurFX(this.field_70170_p, hitX, hitY, hitZ, scale, dx, dy, dz, red, green, blue, ageMultiplier);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)blur);
        }
    }

    public static VengeanceSpirit spawnRandom(World world, int x, int y, int z, int area) {
        VengeanceSpirit spirit = new VengeanceSpirit(world);
        int baseDistance = 5;
        for (int attempts = 50; VengeanceSpirit.canSpawnNew(world, x, y, z) && attempts > 0; --attempts) {
            int posZ;
            int posY;
            int posX = x + MathHelper.func_76136_a((Random)world.field_73012_v, (int)baseDistance, (int)(baseDistance + area)) * MathHelper.func_76136_a((Random)world.field_73012_v, (int)-1, (int)1);
            if (!World.func_147466_a((IBlockAccess)world, (int)posX, (int)((posY = y + MathHelper.func_76136_a((Random)world.field_73012_v, (int)0, (int)3) * MathHelper.func_76136_a((Random)world.field_73012_v, (int)-1, (int)1)) - 1), (int)(posZ = z + MathHelper.func_76136_a((Random)world.field_73012_v, (int)baseDistance, (int)(baseDistance + area)) * MathHelper.func_76136_a((Random)world.field_73012_v, (int)-1, (int)1)))) continue;
            spirit.func_70107_b((double)posX + 0.5, (double)posY + 0.5, (double)posZ + 0.5);
            if (!world.func_72855_b(spirit.field_70121_D) || !world.func_72945_a((Entity)spirit, spirit.field_70121_D).isEmpty() || world.func_72953_d(spirit.field_70121_D)) continue;
            world.func_72838_d((Entity)spirit);
            spirit.func_110161_a(null);
            attempts = -1;
            return spirit;
        }
        return null;
    }

    public String getLocalizedInnerEntityName() {
        if (this.func_70684_aJ()) {
            return this.getPlayerName();
        }
        String key = DEFAULT_L10N_KEY;
        if (this.getInnerEntity() != null) {
            key = (String)EntityList.field_75626_c.get(this.getInnerEntity().getClass());
        }
        return L10NHelpers.getLocalizedEntityName(key);
    }

    @Override
    protected String func_70673_aS() {
        if (this.getInnerEntity() != null) {
            return ObfuscationHelpers.getDeathSound(this.getInnerEntity());
        }
        return "vengeanceSpiritDeath";
    }

    protected String func_70639_aQ() {
        EntityLivingBase entity = this.getInnerEntity();
        if (entity != null && entity instanceof EntityLiving) {
            return ObfuscationHelpers.getLivingSound((EntityLiving)this.getInnerEntity());
        }
        return DEFAULT_L10N_KEY;
    }

    public void func_85030_a(String sound, float volume, float frequency) {
        if (this.isVisible() && sound != null) {
            if (this.isSwarm()) {
                EvilCraft.proxy.playSound(this.field_70165_t, this.field_70163_u, this.field_70161_v, sound, volume, frequency);
            } else {
                EvilCraft.proxy.playSoundMinecraft(this.field_70165_t, this.field_70163_u, this.field_70161_v, sound, volume, frequency);
            }
        }
    }

    @Optional.Method(modid="Thaumcraft")
    private void addWarp(EntityPlayer player) {
        if (GeneralConfig.thaumcraftVengeanceSpiritWarp) {
            ThaumcraftApiHelper.addWarpToPlayer((EntityPlayer)player, (int)1, (boolean)true);
        }
    }

    public static void addToBlacklist(Class<? extends EntityLivingBase> clazz) {
        if (BLACKLIST.add(clazz)) {
            EvilCraft.log("Added entity class " + clazz.getCanonicalName() + " to the spirit blacklist.");
        }
    }

    public static void addToBlacklistIMC(Class<? extends EntityLivingBase> clazz) {
        IMC_BLACKLIST.add(clazz);
        VengeanceSpirit.addToBlacklist(clazz);
    }

    protected static void setBlacklist(String[] blacklist) {
        BLACKLIST.clear();
        for (String entity : blacklist) {
            Class clazz = (Class)EntityList.field_75625_b.get(entity);
            if (clazz == null) {
                EvilCraft.log("Could not find entity by name '" + entity + "' for spirit blacklist.", Level.ERROR);
                continue;
            }
            VengeanceSpirit.addToBlacklist(clazz);
        }
        for (Class clazz : IMC_BLACKLIST) {
            VengeanceSpirit.addToBlacklist(clazz);
        }
        VengeanceSpirit.addToBlacklist(VengeanceSpirit.class);
        VengeanceSpirit.addToBlacklist(ControlledZombie.class);
        VengeanceSpirit.addToBlacklist(EntityDragon.class);
    }

    @Override
    public ExtendedConfig<?> getConfig() {
        return null;
    }

    public boolean func_70072_I() {
        return this.field_70171_ac;
    }

    public static class SpiritBlacklistChanged
    implements IChangedCallback {
        private static boolean calledOnce = false;

        @Override
        public void onChanged(Object value) {
            if (calledOnce) {
                VengeanceSpirit.setBlacklist((String[])value);
            }
            calledOnce = true;
        }

        @Override
        public void onRegisteredPostInit(Object value) {
            this.onChanged(value);
        }
    }
}

