/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.event;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import evilcraft.Configs;
import evilcraft.core.helper.EnchantmentHelpers;
import evilcraft.enchantment.EnchantmentBreaking;
import evilcraft.enchantment.EnchantmentBreakingConfig;
import evilcraft.enchantment.EnchantmentLifeStealing;
import evilcraft.enchantment.EnchantmentLifeStealingConfig;
import evilcraft.enchantment.EnchantmentPoisonTip;
import evilcraft.enchantment.EnchantmentPoisonTipConfig;
import evilcraft.enchantment.EnchantmentUnusing;
import evilcraft.enchantment.EnchantmentUnusingConfig;
import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingAttackEvent;

public class LivingAttackEventHook {
    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onLivingAttack(LivingAttackEvent event) {
        this.stealLife(event);
        this.unusingEvent(event);
        this.breakingEvent(event);
        this.poisonTipEvent(event);
    }

    private void stealLife(LivingAttackEvent event) {
        EntityPlayer player;
        ItemStack itemStack;
        int enchantmentListID;
        if (Configs.isEnabled(EnchantmentLifeStealingConfig.class) && event.source.func_76346_g() instanceof EntityPlayer && (enchantmentListID = EnchantmentHelpers.doesEnchantApply(itemStack = (player = (EntityPlayer)event.source.func_76346_g()).func_71045_bC(), EnchantmentLifeStealingConfig._instance.ID)) > -1) {
            float damage = event.ammount;
            int level = EnchantmentHelpers.getEnchantmentLevel(itemStack, enchantmentListID);
            EnchantmentLifeStealing.stealLife((EntityLivingBase)player, damage, level);
        }
    }

    private void unusingEvent(LivingAttackEvent event) {
        EntityLivingBase entity;
        ItemStack itemStack;
        if (Configs.isEnabled(EnchantmentUnusingConfig.class) && event.source.func_76346_g() instanceof EntityLivingBase && EnchantmentHelpers.doesEnchantApply(itemStack = (entity = (EntityLivingBase)event.source.func_76346_g()).func_71124_b(0), EnchantmentUnusingConfig._instance.ID) > -1 && EnchantmentUnusing.unuseTool(itemStack)) {
            event.setCanceled(true);
        }
    }

    private void breakingEvent(LivingAttackEvent event) {
        EntityLivingBase entity;
        ItemStack itemStack;
        int enchantmentListID;
        if (Configs.isEnabled(EnchantmentBreakingConfig.class) && event.source.func_76346_g() instanceof EntityLivingBase && (enchantmentListID = EnchantmentHelpers.doesEnchantApply(itemStack = (entity = (EntityLivingBase)event.source.func_76346_g()).func_71124_b(0), EnchantmentBreakingConfig._instance.ID)) > -1) {
            EnchantmentBreaking.amplifyDamage(itemStack, enchantmentListID, new Random());
        }
    }

    private void poisonTipEvent(LivingAttackEvent event) {
        EntityLivingBase entity;
        ItemStack itemStack;
        int enchantmentListID;
        if (Configs.isEnabled(EnchantmentPoisonTipConfig.class) && event.source.func_76346_g() instanceof EntityLivingBase && (enchantmentListID = EnchantmentHelpers.doesEnchantApply(itemStack = (entity = (EntityLivingBase)event.source.func_76346_g()).func_71124_b(0), EnchantmentPoisonTipConfig._instance.ID)) > -1) {
            int level = EnchantmentHelpers.getEnchantmentLevel(itemStack, enchantmentListID);
            EnchantmentPoisonTip.poison((EntityLivingBase)event.entity, level);
        }
    }
}

