/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.event;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import evilcraft.Configs;
import evilcraft.ExtendedDamageSource;
import evilcraft.GeneralConfig;
import evilcraft.block.ExcrementPile;
import evilcraft.block.ExcrementPileConfig;
import evilcraft.core.helper.WorldHelpers;
import evilcraft.entity.monster.Werewolf;
import evilcraft.entity.villager.WerewolfVillagerConfig;
import net.minecraft.block.Block;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;

public class LivingUpdateEventHook {
    private static final int CHANCE_DROP_EXCREMENT = 500;
    private static final int CHANCE_DIE_WITHOUT_ANY_REASON = 1000000;

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (WorldHelpers.efficientTick(event.entity.field_70170_p, 80, new int[0])) {
            this.dropExcrement(event);
            this.dieWithoutAnyReason(event);
            this.transformWerewolfVillager(event);
        }
    }

    private void dropExcrement(LivingEvent.LivingUpdateEvent event) {
        if (event.entity instanceof EntityAnimal && Configs.isEnabled(ExcrementPileConfig.class) && !event.entity.field_70170_p.field_72995_K && event.entity.field_70170_p.field_73012_v.nextInt(500) == 0) {
            int z;
            int y;
            EntityAnimal entity = (EntityAnimal)event.entity;
            World world = entity.field_70170_p;
            int x = MathHelper.func_76128_c((double)entity.field_70165_t);
            if (world.func_147439_a(x, y = MathHelper.func_76128_c((double)entity.field_70163_u), z = MathHelper.func_76128_c((double)entity.field_70161_v)) == Blocks.field_150350_a && world.func_147439_a(x, y - 1, z).func_149721_r()) {
                world.func_147449_b(x, y, z, (Block)ExcrementPile.getInstance());
            } else if (world.func_147439_a(x, y, z) == ExcrementPile.getInstance()) {
                ExcrementPile.heightenPileAt(world, x, y, z);
            }
        }
    }

    private void dieWithoutAnyReason(LivingEvent.LivingUpdateEvent event) {
        if (event.entity instanceof EntityPlayer && GeneralConfig.dieWithoutAnyReason && event.entity.field_70170_p.field_73012_v.nextInt(1000000) == 0 && !event.entity.field_70170_p.field_72995_K) {
            EntityPlayer entity = (EntityPlayer)event.entity;
            entity.func_70097_a((DamageSource)ExtendedDamageSource.dieWithoutAnyReason, Float.MAX_VALUE);
        }
    }

    private void transformWerewolfVillager(LivingEvent.LivingUpdateEvent event) {
        if (event.entity instanceof EntityVillager && !event.entity.field_70170_p.field_72995_K) {
            EntityVillager villager = (EntityVillager)event.entity;
            if (Werewolf.isWerewolfTime(event.entity.field_70170_p) && Configs.isEnabled(WerewolfVillagerConfig.class) && villager.func_70946_n() == WerewolfVillagerConfig._instance.getId()) {
                Werewolf.replaceVillager(villager);
            }
        }
    }
}

