/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.event;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import evilcraft.Configs;
import evilcraft.core.helper.EnchantmentHelpers;
import evilcraft.enchantment.EnchantmentBreaking;
import evilcraft.enchantment.EnchantmentBreakingConfig;
import evilcraft.enchantment.EnchantmentUnusing;
import evilcraft.enchantment.EnchantmentUnusingConfig;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class PlayerInteractEventHook {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPlayerInteract(PlayerInteractEvent event) {
        this.unusingEvent(event);
        this.breakingEvent(event);
    }

    private void unusingEvent(PlayerInteractEvent event) {
        if (Configs.isEnabled(EnchantmentUnusingConfig.class) && this.doesEnchantApply(event, EnchantmentUnusingConfig._instance.ID) > -1 && event.entityPlayer != null && EnchantmentUnusing.unuseTool(event.entityPlayer.func_71045_bC())) {
            event.setCanceled(true);
            event.entityPlayer.func_71034_by();
        }
    }

    private void breakingEvent(PlayerInteractEvent event) {
        if (Configs.isEnabled(EnchantmentBreakingConfig.class)) {
            int i = this.doesEnchantApply(event, EnchantmentBreakingConfig._instance.ID);
            ItemStack itemStack = event.entityPlayer.func_71045_bC();
            EnchantmentBreaking.amplifyDamage(itemStack, i, new Random());
        }
    }

    private int doesEnchantApply(PlayerInteractEvent event, int enchantID) {
        if (event.action.equals((Object)PlayerInteractEvent.Action.LEFT_CLICK_BLOCK) && event.entityPlayer != null) {
            ItemStack itemStack = event.entityPlayer.func_71045_bC();
            return EnchantmentHelpers.doesEnchantApply(itemStack, enchantID);
        }
        return -1;
    }
}

