/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.event;

import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import evilcraft.core.fluid.WorldSharedTank;
import evilcraft.core.fluid.WorldSharedTankCache;
import evilcraft.core.world.GlobalCounter;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldSavedData;

public class ServerStatusEventHook {
    private static ServerStatusEventHook _instance = null;

    private ServerStatusEventHook() {
    }

    public static ServerStatusEventHook getInstance() {
        if (_instance == null) {
            _instance = new ServerStatusEventHook();
        }
        return _instance;
    }

    public void onStartedEvent(FMLServerStartedEvent event) {
        this.loadCounters();
        this.loadTankData();
    }

    public void onStoppingEvent(FMLServerStoppingEvent event) {
        this.saveCounters();
        this.saveTankData();
    }

    private GlobalCounter.GlobalCounterData getCounterData() {
        GlobalCounter.GlobalCounterData data = (GlobalCounter.GlobalCounterData)MinecraftServer.func_71276_C().field_71305_c[0].func_72943_a(GlobalCounter.GlobalCounterData.class, GlobalCounter.GlobalCounterData.KEY);
        if (data == null) {
            data = new GlobalCounter.GlobalCounterData(GlobalCounter.GlobalCounterData.KEY);
            MinecraftServer.func_71276_C().field_71305_c[0].func_72823_a(GlobalCounter.GlobalCounterData.KEY, (WorldSavedData)data);
        }
        return data;
    }

    private void loadCounters() {
        GlobalCounter.getInstance().reset();
        GlobalCounter.getInstance().readFromNBT(this.getCounterData().tag);
    }

    private void saveCounters() {
        GlobalCounter.GlobalCounterData data = this.getCounterData();
        GlobalCounter.getInstance().writeToNBT(data.tag);
        data.func_76186_a(true);
    }

    private WorldSharedTank.TankData getTankData() {
        WorldSharedTank.TankData data = (WorldSharedTank.TankData)MinecraftServer.func_71276_C().field_71305_c[0].func_72943_a(WorldSharedTank.TankData.class, "WorldSharedTanks");
        if (data == null) {
            data = new WorldSharedTank.TankData("WorldSharedTanks");
            MinecraftServer.func_71276_C().field_71305_c[0].func_72823_a("WorldSharedTanks", (WorldSavedData)data);
        }
        return data;
    }

    private void loadTankData() {
        WorldSharedTankCache.getInstance().reset();
        WorldSharedTankCache.getInstance().readFromNBT(this.getTankData().getTankTag());
    }

    private void saveTankData() {
        WorldSharedTank.TankData data = this.getTankData();
        WorldSharedTankCache.getInstance().writeToNBT(data.getTankTag());
        data.func_76186_a(true);
    }
}

