/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.infobook.pageelement;

import evilcraft.api.recipes.custom.IRecipe;
import evilcraft.block.BloodInfuser;
import evilcraft.client.gui.container.GuiOriginsOfDarkness;
import evilcraft.core.recipe.custom.DurationXpRecipeProperties;
import evilcraft.core.recipe.custom.ItemFluidStackAndTierRecipeComponent;
import evilcraft.core.recipe.custom.ItemStackRecipeComponent;
import evilcraft.infobook.AdvancedButton;
import evilcraft.infobook.InfoSection;
import evilcraft.infobook.pageelement.RecipeAppendix;
import evilcraft.item.BucketBloodConfig;
import evilcraft.item.Promise;
import net.minecraft.block.Block;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class BloodInfuserRecipeAppendix
extends RecipeAppendix<IRecipe<ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties>> {
    private static final int SLOT_OFFSET_X = 16;
    private static final int SLOT_OFFSET_Y = 23;
    private static final int START_X_RESULT = 68;
    private static final AdvancedButton.Enum INPUT = AdvancedButton.Enum.create();
    private static final AdvancedButton.Enum RESULT = AdvancedButton.Enum.create();
    private static final AdvancedButton.Enum PROMISE = AdvancedButton.Enum.create();

    public BloodInfuserRecipeAppendix(IRecipe<ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties> recipe) {
        super(recipe);
    }

    @Override
    protected int getWidth() {
        return 100;
    }

    @Override
    protected int getHeightInner() {
        return 42;
    }

    @Override
    protected String getUnlocalizedTitle() {
        return "tile.blocks.bloodInfuser.name";
    }

    @Override
    public void bakeElement(InfoSection infoSection) {
        this.renderItemHolders.put(INPUT, new RecipeAppendix.ItemButton());
        this.renderItemHolders.put(RESULT, new RecipeAppendix.ItemButton());
        this.renderItemHolders.put(PROMISE, new RecipeAppendix.ItemButton());
        super.bakeElement(infoSection);
    }

    @Override
    public void drawElementInner(GuiOriginsOfDarkness gui, int x, int y, int width, int height, int page, int mx, int my) {
        int middle = (width - 16) / 2;
        gui.drawArrowRight(x + middle - 3, y + 23 + 2);
        int tick = this.getTick(gui);
        ItemStack input = this.prepareItemStacks(((ItemFluidStackAndTierRecipeComponent)((IRecipe)this.recipe).getInput()).getItemStacks(), tick);
        ItemStack result = this.prepareItemStacks(((ItemStackRecipeComponent)((IRecipe)this.recipe).getOutput()).getItemStacks(), tick);
        ItemStack promise = null;
        if (((ItemFluidStackAndTierRecipeComponent)((IRecipe)this.recipe).getInput()).getTier() > 0) {
            promise = new ItemStack((Item)Promise.getInstance(), 1, ((ItemFluidStackAndTierRecipeComponent)((IRecipe)this.recipe).getInput()).getTier() - 1);
        }
        this.renderItem(gui, x + 16, y + 23, input, mx, my, INPUT);
        this.renderItem(gui, x + 68, y + 23, result, mx, my, RESULT);
        if (promise != null) {
            this.renderItem(gui, x + 16, y + 2, promise, mx, my, PROMISE);
        }
        this.renderIcon(gui, x + middle, y + 2, BucketBloodConfig._instance.getItemInstance().func_77617_a(0));
        this.renderItem(gui, x + middle, y + 23, new ItemStack((Block)BloodInfuser.getInstance()), mx, my, false, null);
        FontRenderer fontRenderer = gui.getFontRenderer();
        boolean oldUnicode = fontRenderer.func_82883_a();
        fontRenderer.func_78264_a(true);
        fontRenderer.func_78275_b(false);
        FluidStack fluidStack = ((ItemFluidStackAndTierRecipeComponent)((IRecipe)this.recipe).getInput()).getFluidStack();
        String line = fluidStack.amount + " mB";
        fontRenderer.func_78279_b(line, x + middle + 16 + 1, y + 6, 200, 0);
        fontRenderer.func_78264_a(oldUnicode);
    }
}

