/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.infobook.pageelement;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import evilcraft.Configs;
import evilcraft.client.gui.container.GuiOriginsOfDarkness;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.core.helper.L10NHelpers;
import evilcraft.core.helper.RenderHelpers;
import evilcraft.infobook.AdvancedButton;
import evilcraft.infobook.InfoBookParser;
import evilcraft.infobook.InfoSection;
import evilcraft.infobook.pageelement.SectionAppendix;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

public abstract class RecipeAppendix<T>
extends SectionAppendix {
    protected static final int SLOT_SIZE = 16;
    protected static final int TICK_DELAY = 30;
    protected T recipe;
    protected Map<AdvancedButton.Enum, ItemButton> renderItemHolders = Maps.newHashMap();

    public RecipeAppendix(T recipe) {
        this.recipe = recipe;
    }

    protected int getTick(GuiOriginsOfDarkness gui) {
        return gui.getTick() / 30;
    }

    protected ItemStack prepareItemStacks(List<ItemStack> itemStacks, int tick) {
        if (itemStacks.size() == 0) {
            return null;
        }
        return this.prepareItemStack(itemStacks.get(tick % itemStacks.size()).func_77946_l(), tick);
    }

    protected ItemStack prepareItemStack(ItemStack itemStack, int tick) {
        if (itemStack.func_77960_j() == Short.MAX_VALUE) {
            LinkedList itemStacks = Lists.newLinkedList();
            itemStack.func_77973_b().func_150895_a(itemStack.func_77973_b(), null, (List)itemStacks);
            if (itemStacks.isEmpty()) {
                return itemStack;
            }
            return (ItemStack)itemStacks.get(tick % itemStacks.size());
        }
        return itemStack;
    }

    protected void renderItem(GuiOriginsOfDarkness gui, int x, int y, ItemStack itemStack, int mx, int my, AdvancedButton.Enum buttonEnum) {
        this.renderItem(gui, x, y, itemStack, mx, my, true, buttonEnum);
    }

    protected void renderItem(GuiOriginsOfDarkness gui, int x, int y, ItemStack itemStack, int mx, int my, boolean renderOverlays, AdvancedButton.Enum buttonEnum) {
        if (renderOverlays) {
            gui.drawOuterBorder(x, y, 16, 16, 1.0f, 1.0f, 1.0f, 0.2f);
        }
        RenderItem renderItem = RenderItem.getInstance();
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderHelper.func_74520_c();
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2929);
        renderItem.func_82406_b(Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().func_110434_K(), itemStack, x, y);
        if (renderOverlays) {
            renderItem.func_77021_b(Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().func_110434_K(), itemStack, x, y);
        }
        RenderHelper.func_74518_a();
        GL11.glPopMatrix();
        GL11.glDisable((int)2929);
        if (buttonEnum != null && renderOverlays) {
            this.renderItemHolders.get(buttonEnum).update(x, y, itemStack, gui);
        }
    }

    protected void renderIcon(GuiOriginsOfDarkness gui, int x, int y, IIcon icon) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110576_c);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderHelper.func_74520_c();
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2929);
        RenderItem.getInstance().func_94149_a(x, y, icon, 16, 16);
        RenderHelper.func_74518_a();
        GL11.glPopMatrix();
    }

    protected void renderItemTooltip(GuiOriginsOfDarkness gui, int x, int y, ItemStack itemStack, int mx, int my) {
        GL11.glPushMatrix();
        if (mx >= x && my >= y && mx <= x + 16 && my <= y + 16 && itemStack != null) {
            gui.func_146285_a(itemStack, mx, my);
        }
        GL11.glPopMatrix();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
    }

    @Override
    protected int getHeight() {
        return this.getHeightInner() + this.getAdditionalHeight();
    }

    protected abstract int getHeightInner();

    protected int getAdditionalHeight() {
        return 5;
    }

    @Override
    protected int getOffsetY() {
        return this.getAdditionalHeight();
    }

    protected abstract String getUnlocalizedTitle();

    @Override
    public final void drawElement(GuiOriginsOfDarkness gui, int x, int y, int width, int height, int page, int mx, int my) {
        int yOffset = this.getAdditionalHeight();
        gui.drawOuterBorder(x - 1, y - 1 - yOffset, this.getWidth() + 2, this.getHeight() + 2, 0.5f, 0.5f, 0.5f, 0.4f);
        gui.drawTextBanner(x + width / 2, y - 2 - yOffset);
        gui.drawScaledCenteredString(L10NHelpers.localize(this.getUnlocalizedTitle()), x, y - 2 - yOffset, width, 0.9f, 85, RenderHelpers.RGBToInt(120, 20, 30));
        this.drawElementInner(gui, x, y, width, height, page, mx, my);
    }

    @Override
    protected void postDrawElement(GuiOriginsOfDarkness gui, int x, int y, int width, int height, int page, int mx, int my) {
        this.renderToolTips(gui, mx, my);
    }

    protected abstract void drawElementInner(GuiOriginsOfDarkness var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    protected void renderToolTips(GuiOriginsOfDarkness gui, int mx, int my) {
        for (ItemButton renderItemHolder : this.renderItemHolders.values()) {
            this.renderItemTooltip(gui, renderItemHolder.field_146128_h, renderItemHolder.field_146129_i, renderItemHolder.getItemStack(), mx, my);
        }
    }

    @Override
    public void preBakeElement(InfoSection infoSection) {
        this.renderItemHolders.clear();
    }

    @Override
    public void bakeElement(InfoSection infoSection) {
        infoSection.addAdvancedButtons(this.getPage(), this.renderItemHolders.values());
    }

    protected static class ItemButton
    extends AdvancedButton {
        private ItemStack itemStack;

        public void update(int x, int y, ItemStack itemStack, GuiOriginsOfDarkness gui) {
            Pair<InfoSection, Integer> pair;
            ExtendedConfig<?> config;
            this.itemStack = itemStack;
            InfoSection target = null;
            if (this.itemStack != null && (config = Configs.getConfigFromItem(itemStack.func_77973_b())) != null && (pair = InfoBookParser.configLinks.get(config.getFullUnlocalizedName())) != null) {
                target = (InfoSection)pair.getLeft();
            }
            super.update(x, y, "empty", target, gui);
        }

        @Override
        public void func_146112_a(Minecraft minecraft, int mouseX, int mouseY) {
            if (this.isVisible() && this.isHover(mouseX, mouseY)) {
                this.gui.drawOuterBorder(this.field_146128_h, this.field_146129_i, 16, 16, 0.392f, 0.392f, 0.6f, 0.9f);
            }
        }

        @Override
        public boolean isVisible() {
            return super.isVisible() && this.itemStack != null;
        }

        public ItemStack getItemStack() {
            return this.itemStack;
        }
    }
}

