/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.item;

import com.google.common.collect.Sets;
import evilcraft.EvilCraft;
import evilcraft.core.config.ConfigurableProperty;
import evilcraft.core.config.ConfigurableTypeCategory;
import evilcraft.core.config.IChangedCallback;
import evilcraft.core.config.extendedconfig.ItemConfig;
import evilcraft.item.BiomeExtract;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.world.biome.BiomeGenBase;

public class BiomeExtractConfig
extends ItemConfig {
    public static BiomeExtractConfig _instance;
    @ConfigurableProperty(category=ConfigurableTypeCategory.ITEM, comment="If creative versions for all variants should be added to the creative tab.", requiresMcRestart=true)
    public static boolean creativeTabVariants;
    @ConfigurableProperty(category=ConfigurableTypeCategory.ITEM, comment="If this should have recipes inside the Environmental Accumulator.", requiresMcRestart=true)
    public static boolean hasRecipes;
    @ConfigurableProperty(category=ConfigurableTypeCategory.ITEM, comment="The cooldown time int the Environmental Accumulator recipe.", requiresMcRestart=true)
    public static int envirAccCooldownTime;
    @ConfigurableProperty(category=ConfigurableTypeCategory.ITEM, comment="A list of biome ids for which no Biome Extracts may be created.", changedCallback=CraftingBlacklistChanged.class)
    public static String[] craftingBlacklist;
    @ConfigurableProperty(category=ConfigurableTypeCategory.ITEM, comment="A list of biome ids for which no Biome Extracts may be used.", changedCallback=UsageBlacklistChanged.class)
    public static String[] usageBlacklist;
    private Set<Integer> craftingBlacklistIds = Sets.newHashSet();
    private Set<Integer> usageBlacklistIds = Sets.newHashSet();

    public BiomeExtractConfig() {
        super(true, "biomeExtract", (String)null, (Class<? extends Item>)BiomeExtract.class);
    }

    public void setBlacklist(String[] config, Set<Integer> blacklistIds) {
        blacklistIds.clear();
        for (String line : config) {
            try {
                int biomeId = Integer.parseInt(line);
                if (biomeId >= BiomeGenBase.func_150565_n().length || BiomeGenBase.func_150565_n()[biomeId] == null) {
                    EvilCraft.log("Invalid line '" + line + "' found for a Biome Extract blacklist config: " + line + " does not refer to an existing biome; skipping.");
                }
                blacklistIds.add(biomeId);
            }
            catch (NumberFormatException e) {
                EvilCraft.log("Invalid line '" + line + "' found for a Biome Extract blacklist config: " + line + " is not a number; skipping.");
            }
        }
    }

    public boolean isCraftingBlacklisted(int biomeId) {
        return this.craftingBlacklistIds.contains(biomeId);
    }

    public boolean isUsageBlacklisted(int biomeId) {
        return this.usageBlacklistIds.contains(biomeId);
    }

    static {
        creativeTabVariants = true;
        hasRecipes = true;
        envirAccCooldownTime = 500;
        craftingBlacklist = new String[]{String.valueOf(BiomeGenBase.field_76779_k.field_76756_M)};
        usageBlacklist = new String[]{String.valueOf(BiomeGenBase.field_76779_k.field_76756_M)};
    }

    public static class UsageBlacklistChanged
    implements IChangedCallback {
        private static boolean calledOnce = false;

        @Override
        public void onChanged(Object value) {
            if (calledOnce) {
                _instance.setBlacklist((String[])value, _instance.usageBlacklistIds);
            }
            calledOnce = true;
        }

        @Override
        public void onRegisteredPostInit(Object value) {
            this.onChanged(value);
        }
    }

    public static class CraftingBlacklistChanged
    implements IChangedCallback {
        private static boolean calledOnce = false;

        @Override
        public void onChanged(Object value) {
            if (calledOnce) {
                _instance.setBlacklist((String[])value, _instance.craftingBlacklistIds);
            }
            calledOnce = true;
        }

        @Override
        public void onRegisteredPostInit(Object value) {
            this.onChanged(value);
        }
    }
}

