/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.Configs;
import evilcraft.block.BloodStainedBlock;
import evilcraft.block.BloodStainedBlockConfig;
import evilcraft.client.particle.EntityBloodSplashFX;
import evilcraft.core.PlayerInventoryIterator;
import evilcraft.core.algorithm.Location;
import evilcraft.core.config.configurable.ConfigurableBlockWithInnerBlocksExtended;
import evilcraft.core.config.configurable.ConfigurableDamageIndicatedItemFluidContainer;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.core.config.extendedconfig.ItemConfig;
import evilcraft.core.helper.ItemHelpers;
import evilcraft.core.helper.L10NHelpers;
import evilcraft.fluid.Blood;
import evilcraft.item.BloodExtractorConfig;
import evilcraft.tileentity.TileBloodStainedBlock;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.ItemFluidContainer;

public class BloodExtractor
extends ConfigurableDamageIndicatedItemFluidContainer {
    private static final String NBT_TAG_CAPACITY = "tankCapacity";
    private static BloodExtractor _instance = null;

    public static void initInstance(ExtendedConfig<ItemConfig> eConfig) {
        if (_instance == null) {
            _instance = new BloodExtractor(eConfig);
        } else {
            eConfig.showDoubleInitError();
        }
    }

    public static BloodExtractor getInstance() {
        return _instance;
    }

    private BloodExtractor(ExtendedConfig<ItemConfig> eConfig) {
        super(eConfig, BloodExtractorConfig.containerSize, Blood.getInstance());
        this.setPlaceFluids(true);
    }

    @Override
    public boolean onItemUseFirst(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        Block block = world.func_147439_a(x, y, z);
        if (player.func_70093_af() && Configs.isEnabled(BloodStainedBlockConfig.class) && block == BloodStainedBlock.getInstance()) {
            Random random = world.field_73012_v;
            int amount = 0;
            try {
                amount = ((TileBloodStainedBlock)BloodStainedBlock.getInstance().getTile((IBlockAccess)world, x, y, z)).getAmount();
            }
            catch (ConfigurableBlockWithInnerBlocksExtended.InvalidInnerBlocksTileException e) {
                e.printStackTrace();
            }
            int filled = this.fillBloodExtractor(itemStack, amount, !world.field_72995_K);
            BloodStainedBlock.getInstance().unstainBlock(world, new Location(x, y, z), filled);
            if (filled > 0 && world.field_72995_K) {
                EntityBloodSplashFX.spawnParticles(world, x, y + 1, z, 5, 1 + random.nextInt(2));
            }
            return false;
        }
        return super.onItemUseFirst(itemStack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }

    public boolean hasEffect(ItemStack itemStack, int pass) {
        return ItemHelpers.isActivated(itemStack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.func_77624_a(itemStack, entityPlayer, list, par4);
        L10NHelpers.addStatusInfo(list, ItemHelpers.isActivated(itemStack), this.func_77658_a() + ".info.autoSupply");
    }

    @Override
    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (!player.func_70093_af()) {
            return super.func_77659_a(itemStack, world, player);
        }
        MovingObjectPosition target = this.func_77621_a(world, player, false);
        if (!(target != null && target.field_72313_a != MovingObjectPosition.MovingObjectType.MISS || world.field_72995_K)) {
            ItemHelpers.toggleActivation(itemStack);
        }
        return itemStack;
    }

    public int fillBloodExtractor(ItemStack itemStack, int amount, boolean doFill) {
        ItemFluidContainer container = (ItemFluidContainer)itemStack.func_77973_b();
        int filled = container.fill(itemStack, new FluidStack((Fluid)Blood.getInstance(), amount), doFill);
        return filled;
    }

    public void fillForAllBloodExtractors(EntityPlayer player, int minimumMB, int maximumMB) {
        int toFill = minimumMB + field_77697_d.nextInt(Math.max(1, maximumMB - minimumMB));
        PlayerInventoryIterator it = new PlayerInventoryIterator(player);
        while (it.hasNext() && toFill > 0) {
            ItemStack itemStack = it.next();
            if (itemStack == null || itemStack.func_77973_b() != BloodExtractor.getInstance()) continue;
            ItemFluidContainer container = (ItemFluidContainer)itemStack.func_77973_b();
            toFill -= container.fill(itemStack, new FluidStack((Fluid)Blood.getInstance(), toFill), true);
        }
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        if (ItemHelpers.isActivated(itemStack)) {
            ItemHelpers.updateAutoFill((IFluidContainerItem)this, itemStack, world, entity);
        }
        super.func_77663_a(itemStack, world, entity, par4, par5);
    }

    public void setCapacity(ItemStack itemStack, int capacity) {
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            itemStack.func_77982_d(tag);
        }
        tag.func_74768_a(NBT_TAG_CAPACITY, capacity);
    }

    public int getCapacity(ItemStack itemStack) {
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag == null || !tag.func_74764_b(NBT_TAG_CAPACITY)) {
            return super.getCapacity(itemStack);
        }
        return tag.func_74762_e(NBT_TAG_CAPACITY);
    }
}

